/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl.http;

import io.camunda.connector.generator.dsl.HiddenProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyConstraints;
import io.camunda.connector.generator.dsl.StringProperty;
import java.util.List;
import java.util.Set;

public interface HttpAuthentication {
    public String label();

    public String id();

    public static List<PropertyBuilder> getPropertyPrefabs(HttpAuthentication auth) {
        if (auth instanceof OAuth2) {
            return List.of(HiddenProperty.builder().value("oauth-client-credentials-flow").group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.type")), StringProperty.builder().id("authentication.oauthTokenEndpoint").label("Oauth token endpoint").description("The OAuth token endpoint").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").value(((OAuth2)auth).tokenUrl()).binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.oauthTokenEndpoint")), StringProperty.builder().id("authentication.clientId").label("Client id").description("Your application's client ID from the OAuth client").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.clientId")), StringProperty.builder().id("authentication.clientSecret").label("Client secret").description("Your application's client secret from the OAuth client").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.clientSecret")), StringProperty.builder().id("authentication.audience").label("Audience").description("The unique identifier of the target API you want to access (optional)").optional(true).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.audience")), StringProperty.builder().id("authentication.scopes").label("Scopes").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).description("The scopes which you want to request authorization for (e.g.read:contacts)").value(String.join((CharSequence)" ", ((OAuth2)auth).scopes())).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.scopes")));
        }
        if (auth instanceof BasicAuth) {
            return List.of(HiddenProperty.builder().value("basic").group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.type")), StringProperty.builder().id("authentication.username").label("Username").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.username")), StringProperty.builder().id("authentication.password").label("Password").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.password")));
        }
        if (auth instanceof BearerAuth) {
            return List.of(HiddenProperty.builder().value("bearer").group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.type")), StringProperty.builder().id("authentication.token").label("Bearer token").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.token")));
        }
        if (auth instanceof NoAuth) {
            return List.of(HiddenProperty.builder().value("noAuth").group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.type")));
        }
        if (auth instanceof ApiKey) {
            ApiKey apiKey = (ApiKey)auth;
            return List.of(HiddenProperty.builder().value("apiKey").group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.type")), HiddenProperty.builder().value(apiKey.in).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.apiKeyLocation")), StringProperty.builder().id("authentication.name").label("API key name").value(apiKey.key() != null ? apiKey.key() : "").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.name")), StringProperty.builder().id("authentication.value").label("API key value").value(apiKey.value() != null ? apiKey.value() : "").optional(false).constraints(PropertyConstraints.builder().notEmpty(true).build()).feel(Property.FeelMode.optional).group("authentication").binding((PropertyBinding)new PropertyBinding.ZeebeInput("authentication.value")));
        }
        throw new IllegalArgumentException("Unknown authentication type: " + String.valueOf(auth));
    }

    public record OAuth2(String tokenUrl, Set<String> scopes) implements HttpAuthentication
    {
        @Override
        public String label() {
            return "OAuth 2.0";
        }

        @Override
        public String id() {
            return "oauth-client-credentials-flow";
        }
    }

    public static class BasicAuth
    implements HttpAuthentication {
        public static final BasicAuth INSTANCE = new BasicAuth();

        @Override
        public String label() {
            return "Basic";
        }

        @Override
        public String id() {
            return "basic";
        }
    }

    public static class BearerAuth
    implements HttpAuthentication {
        public static final BearerAuth INSTANCE = new BearerAuth();

        @Override
        public String label() {
            return "Bearer token";
        }

        @Override
        public String id() {
            return "bearer";
        }
    }

    public static class NoAuth
    implements HttpAuthentication {
        public static final NoAuth INSTANCE = new NoAuth();

        @Override
        public String label() {
            return "None";
        }

        @Override
        public String id() {
            return "noAuth";
        }
    }

    public record ApiKey(String in, String key, String value) implements HttpAuthentication
    {
        @Override
        public String label() {
            return "API key";
        }

        @Override
        public String id() {
            return "apiKey";
        }
    }
}

