/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound.model;

import connector.com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.connector.rabbitmq.common.model.CredentialsAuthentication;
import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthentication;
import io.camunda.connector.rabbitmq.common.model.UriAuthentication;
import io.camunda.connector.rabbitmq.outbound.model.RabbitMqMessage;
import io.camunda.connector.rabbitmq.outbound.model.RabbitMqOutboundRouting;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.NotNull;

public record RabbitMqRequest(@Valid @NotNull RabbitMqAuthentication authentication, @Valid @NotNull RabbitMqOutboundRouting routing, @Valid @NotNull RabbitMqMessage message) {
    @JsonIgnore
    @AssertFalse
    public boolean isRoutingParamsNotFilling() {
        if (this.authentication instanceof UriAuthentication) {
            return false;
        }
        if (this.authentication instanceof CredentialsAuthentication && this.routing != null) {
            return this.routing.routingData().port() == null || this.routing.routingData().port().isBlank() || this.routing.routingData().hostName() == null || this.routing.routingData().hostName().isBlank() || this.routing.routingData().virtualHost() == null || this.routing.routingData().virtualHost().isBlank();
        }
        return true;
    }
}

