/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound.model;

import connector.com.fasterxml.jackson.annotation.JsonCreator;
import connector.com.fasterxml.jackson.annotation.JsonProperty;
import connector.com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.camunda.connector.generator.java.annotation.NestedProperties;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.rabbitmq.common.model.FactoryRoutingData;
import jakarta.validation.constraints.NotBlank;

public record RabbitMqOutboundRouting(@NotBlank @TemplateProperty(group="routing", description="Topic exchange: get from RabbitMQ external application configurations. Details in the <a href=\"https://docs.camunda.io/docs/components/connectors/out-of-the-box-connectors/rabbitmq/?rabbitmq=outbound#routing-data\"target=\"_blank\">documentation</a>") String exchange, @NotBlank @TemplateProperty(group="routing", label="Routing key", description="Routing key: a binding is a \"link\" that was set up to bind a queue to an exchange. Details in the <a href=\"https://docs.camunda.io/docs/components/connectors/out-of-the-box-connectors/rabbitmq/?rabbitmq=outbound#routing-data\"target=\"_blank\">documentation</a>") String routingKey, @NestedProperties(addNestedPath=false, condition=@TemplateProperty.PropertyCondition(property="authentication.authType", equals="credentials")) @JsonUnwrapped FactoryRoutingData routingData) {
    @JsonCreator
    public RabbitMqOutboundRouting(@JsonProperty(value="exchange") String exchange, @JsonProperty(value="routingKey") String routingKey, @JsonProperty(value="virtualHost") String virtualHost, @JsonProperty(value="hostName") String hostName, @JsonProperty(value="port") String port) {
        this(exchange, routingKey, new FactoryRoutingData(virtualHost, hostName, port));
    }
}

