/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound;

import com.rabbitmq.client.AMQP;
import connector.com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public final class ValidationPropertiesUtil {
    private ValidationPropertiesUtil() {
    }

    public static JsonNode validateAmqpBasicPropertiesOrThrowException(JsonNode jsonElement) {
        Iterator<Map.Entry<String, JsonNode>> entries = jsonElement.fields();
        while (entries.hasNext()) {
            Map.Entry<String, JsonNode> entry = entries.next();
            boolean fieldExist = Arrays.stream(AMQP.BasicProperties.class.getDeclaredFields()).anyMatch(f -> f.getName().equals(entry.getKey()));
            if (fieldExist) continue;
            throw new IllegalArgumentException("Unsupported field [" + entry.getKey() + "] for properties");
        }
        return jsonElement;
    }
}

