/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import io.camunda.connector.rabbitmq.outbound.MessageUtil;
import io.camunda.connector.rabbitmq.outbound.RabbitMqResult;
import io.camunda.connector.rabbitmq.outbound.model.RabbitMqRequest;
import io.camunda.connector.rabbitmq.supplier.ConnectionFactorySupplier;

@OutboundConnector(name="RabbitMQ Producer", inputVariables={"authentication", "routing", "message"}, type="io.camunda:connector-rabbitmq:1")
@ElementTemplate(id="io.camunda.connectors.RabbitMQ.v1", name="RabbitMQ Outbound Connector", description="Send message to RabbitMQ", inputDataClass=RabbitMqRequest.class, version=5, propertyGroups={@ElementTemplate.PropertyGroup(id="authentication", label="Authentication"), @ElementTemplate.PropertyGroup(id="routing", label="Routing"), @ElementTemplate.PropertyGroup(id="message", label="Message")}, documentationRef="https://docs.camunda.io/docs/components/connectors/out-of-the-box-connectors/rabbitmq/?rabbitmq=outbound", icon="icon.svg")
public class RabbitMqFunction
implements OutboundConnectorFunction {
    private final ConnectionFactorySupplier connectionFactorySupplier;

    public RabbitMqFunction() {
        this.connectionFactorySupplier = new ConnectionFactorySupplier();
    }

    public RabbitMqFunction(ConnectionFactorySupplier connectionFactorySupplier) {
        this.connectionFactorySupplier = connectionFactorySupplier;
    }

    public Object execute(OutboundConnectorContext context) throws Exception {
        RabbitMqRequest request = (RabbitMqRequest)context.bindVariables(RabbitMqRequest.class);
        return this.executeConnector(request);
    }

    private RabbitMqResult executeConnector(RabbitMqRequest request) throws Exception {
        AMQP.BasicProperties messageProperties = MessageUtil.toAmqpBasicProperties(request.message().properties());
        byte[] messageInByteArray = MessageUtil.getBodyAsByteArray(request.message().body());
        try (Connection connection = this.openConnection(request);){
            Channel channel = connection.createChannel();
            channel.basicPublish(request.routing().exchange(), request.routing().routingKey(), messageProperties, messageInByteArray);
            RabbitMqResult rabbitMqResult = RabbitMqResult.success();
            return rabbitMqResult;
        }
    }

    private Connection openConnection(RabbitMqRequest request) throws Exception {
        return this.connectionFactorySupplier.createFactory(request.authentication(), request.routing().routingData()).newConnection();
    }
}

