/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound;

import com.rabbitmq.client.AMQP;
import connector.com.fasterxml.jackson.core.JsonProcessingException;
import connector.com.fasterxml.jackson.databind.JsonNode;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.rabbitmq.outbound.ValidationPropertiesUtil;
import io.camunda.connector.rabbitmq.outbound.model.RabbitMqMessage;
import io.camunda.connector.rabbitmq.supplier.ObjectMapperSupplier;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqMessage.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperSupplier.instance();

    private MessageUtil() {
    }

    public static AMQP.BasicProperties toAmqpBasicProperties(Object properties) {
        return Optional.ofNullable(properties).map(pr -> OBJECT_MAPPER.convertValue(pr, JsonNode.class)).map(ValidationPropertiesUtil::validateAmqpBasicPropertiesOrThrowException).map(jsonProperties -> OBJECT_MAPPER.convertValue(jsonProperties, AMQP.BasicProperties.class)).orElse(null);
    }

    public static byte[] getBodyAsByteArray(Object body) {
        Object resBody = body;
        if (body instanceof String) {
            try {
                JsonNode jsonElement = OBJECT_MAPPER.readTree(StringEscapeUtils.unescapeJson(body.toString()));
                if (jsonElement.isValueNode()) {
                    return ((String)body).getBytes();
                }
                resBody = jsonElement;
            }
            catch (JsonProcessingException e) {
                LOGGER.debug("Expected exception when parsing a plain text value : {}", body, (Object)e);
                return body.toString().getBytes();
            }
        }
        return Optional.of(resBody).map(b -> {
            try {
                return OBJECT_MAPPER.writeValueAsString(b);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).map(StringEscapeUtils::unescapeJson).map(String::getBytes).orElseThrow(() -> new RuntimeException("Parse error to byte array"));
    }
}

