/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.inbound.model;

import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.rabbitmq.common.model.FactoryRoutingData;
import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthentication;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import java.util.Objects;

public class RabbitMqInboundProperties {
    @Valid
    @NotNull
    private RabbitMqAuthentication authentication;
    @Valid
    private FactoryRoutingData routing;
    @NotBlank
    @TemplateProperty(label="Queue name", group="subscription", description="Name of the queue to subscribe to")
    private String queueName;
    @TemplateProperty(label="Consumer tag", group="subscription", description="Consumer tag to use for the subscription")
    private String consumerTag;
    @Valid
    @TemplateProperty(label="Arguments", description="Arguments to use for the subscription", group="subscription", optional=true, feel=Property.FeelMode.required)
    private Map<String, Object> arguments;
    @TemplateProperty(label="Exclusive consumer", group="subscription", type=TemplateProperty.PropertyType.Dropdown, choices={@TemplateProperty.DropdownPropertyChoice(value="true", label="Yes"), @TemplateProperty.DropdownPropertyChoice(value="false", label="No")}, defaultValue="false")
    private boolean exclusive;

    public RabbitMqAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(RabbitMqAuthentication authentication) {
        this.authentication = authentication;
    }

    public FactoryRoutingData getRouting() {
        return this.routing;
    }

    public void setRouting(FactoryRoutingData routing) {
        this.routing = routing;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public void setConsumerTag(String consumerTag) {
        this.consumerTag = consumerTag;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMqInboundProperties that = (RabbitMqInboundProperties)o;
        return this.exclusive == that.exclusive && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.routing, that.routing) && Objects.equals(this.queueName, that.queueName) && Objects.equals(this.consumerTag, that.consumerTag) && Objects.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.authentication, this.routing, this.queueName, this.consumerTag, this.arguments, this.exclusive);
    }

    public String toString() {
        return "RabbitMqInboundProperties{authentication=" + String.valueOf(this.authentication) + ", routing=" + String.valueOf(this.routing) + ", queueName='" + this.queueName + "', consumerTag='" + this.consumerTag + "', arguments=" + String.valueOf(this.arguments) + ", exclusive=" + this.exclusive + "}";
    }
}

