/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.inbound;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import io.camunda.connector.api.annotation.InboundConnector;
import io.camunda.connector.api.inbound.Activity;
import io.camunda.connector.api.inbound.Health;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.api.inbound.InboundConnectorExecutable;
import io.camunda.connector.api.inbound.Severity;
import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import io.camunda.connector.rabbitmq.inbound.RabbitMqConsumer;
import io.camunda.connector.rabbitmq.inbound.model.RabbitMqInboundProperties;
import io.camunda.connector.rabbitmq.supplier.ConnectionFactorySupplier;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InboundConnector(name="RabbitMQ Consumer", type="io.camunda:connector-rabbitmq-inbound:1")
@ElementTemplate(id="io.camunda.connectors.inbound.RabbitMQ", name="RabbitMQ Connector", icon="icon.svg", version=7, inputDataClass=RabbitMqInboundProperties.class, description="Receive a message from RabbitMQ", documentationRef="https://docs.camunda.io/docs/components/connectors/out-of-the-box-connectors/rabbitmq/?rabbitmq=inbound", propertyGroups={@ElementTemplate.PropertyGroup(id="authentication", label="Authentication"), @ElementTemplate.PropertyGroup(id="routing", label="Routing"), @ElementTemplate.PropertyGroup(id="subscription", label="Subscription")}, elementTypes={@ElementTemplate.ConnectorElementType(appliesTo={BpmnType.START_EVENT}, elementType=BpmnType.START_EVENT, templateIdOverride="io.camunda.connectors.inbound.RabbitMQ.StartEvent.v1", templateNameOverride="RabbitMQ Start Event Connector"), @ElementTemplate.ConnectorElementType(appliesTo={BpmnType.START_EVENT}, elementType=BpmnType.MESSAGE_START_EVENT, templateIdOverride="io.camunda.connectors.inbound.RabbitMQ.MessageStart.v1", templateNameOverride="RabbitMQ Message Start Event Connector"), @ElementTemplate.ConnectorElementType(appliesTo={BpmnType.INTERMEDIATE_THROW_EVENT, BpmnType.INTERMEDIATE_CATCH_EVENT}, elementType=BpmnType.INTERMEDIATE_CATCH_EVENT, templateIdOverride="io.camunda.connectors.inbound.RabbitMQ.Intermediate.v1", templateNameOverride="RabbitMQ Intermediate Catch Event Connector"), @ElementTemplate.ConnectorElementType(appliesTo={BpmnType.BOUNDARY_EVENT}, elementType=BpmnType.BOUNDARY_EVENT, templateIdOverride="io.camunda.connectors.inbound.RabbitMQ.Boundary.v1", templateNameOverride="RabbitMQ Boundary Event Connector")})
public class RabbitMqExecutable
implements InboundConnectorExecutable<InboundConnectorContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqExecutable.class);
    private static final int CLOSE_TIMEOUT_MILLIS = 3000;
    private final ConnectionFactorySupplier connectionFactorySupplier;
    private Connection connection;
    private Channel channel;
    private String consumerTag;

    public RabbitMqExecutable() {
        this.connectionFactorySupplier = new ConnectionFactorySupplier();
    }

    public RabbitMqExecutable(ConnectionFactorySupplier connectionFactorySupplier) {
        this.connectionFactorySupplier = connectionFactorySupplier;
    }

    public void activate(InboundConnectorContext context) throws Exception {
        RabbitMqInboundProperties properties = (RabbitMqInboundProperties)context.bindProperties(RabbitMqInboundProperties.class);
        LOGGER.info("Subscription activation requested by the Connector runtime: {}", (Object)properties);
        context.log(Activity.level((Severity)Severity.INFO).tag("Subscription activation").message("Subscription activation requested for queue name :" + properties.getQueueName()));
        this.connection = this.openConnection(properties);
        this.channel = this.connection.createChannel();
        RabbitMqConsumer consumer = new RabbitMqConsumer(this.channel, context);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("connection-id", this.connection.getId());
        data.put("connection-name", this.connection.getClientProvidedName());
        data.put("connection-address", this.connection.getAddress());
        data.put("connection-port", this.connection.getPort());
        context.reportHealth(Health.up(data));
        this.consumerTag = this.startConsumer(properties, consumer);
        LOGGER.info("Started RabbitMQ consumer for queue {}", (Object)properties.getQueueName());
        context.log(Activity.level((Severity)Severity.INFO).tag("Subscription activation").message("Activated subscription for queue: " + properties.getQueueName()));
        context.reportHealth(Health.up());
    }

    public void deactivate() throws Exception {
        LOGGER.info("Subscription deactivation requested by the Connector runtime");
        try {
            this.channel.basicCancel(this.consumerTag);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to cancel consumer", e);
        }
        finally {
            if (this.connection != null) {
                this.connection.close(3000);
            }
        }
    }

    private Connection openConnection(RabbitMqInboundProperties properties) throws Exception {
        return this.connectionFactorySupplier.createFactory(properties.getAuthentication(), properties.getRouting()).newConnection();
    }

    private String startConsumer(RabbitMqInboundProperties properties, Consumer consumer) throws IOException {
        if (StringUtils.isBlank(properties.getConsumerTag())) {
            return this.channel.basicConsume(properties.getQueueName(), false, UUID.randomUUID().toString(), false, properties.isExclusive(), properties.getArguments(), consumer);
        }
        return this.channel.basicConsume(properties.getQueueName(), false, properties.getConsumerTag(), false, properties.isExclusive(), properties.getArguments(), consumer);
    }
}

