/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.inbound;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import connector.com.fasterxml.jackson.core.JsonProcessingException;
import connector.com.fasterxml.jackson.databind.JsonNode;
import connector.com.fasterxml.jackson.databind.node.ValueNode;
import io.camunda.connector.api.error.ConnectorInputException;
import io.camunda.connector.api.inbound.Activity;
import io.camunda.connector.api.inbound.CorrelationFailureHandlingStrategy;
import io.camunda.connector.api.inbound.CorrelationResult;
import io.camunda.connector.api.inbound.Health;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.api.inbound.Severity;
import io.camunda.connector.rabbitmq.inbound.AMQPPropertyUtil;
import io.camunda.connector.rabbitmq.inbound.model.RabbitMqInboundResult;
import io.camunda.connector.rabbitmq.supplier.ObjectMapperSupplier;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMqConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqConsumer.class);
    private final InboundConnectorContext context;

    public RabbitMqConsumer(Channel channel, InboundConnectorContext context) {
        super(channel);
        this.context = context;
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        LOGGER.debug("Received AMQP message with delivery tag {}", (Object)envelope.getDeliveryTag());
        this.context.log(Activity.level((Severity)Severity.INFO).tag("Message").message("Received AMQP message with delivery tag " + envelope.getDeliveryTag()));
        try {
            RabbitMqInboundResult variables = this.prepareVariables(consumerTag, properties, body);
            CorrelationResult result = this.context.correlateWithResult((Object)variables);
            this.handleCorrelationResult(envelope, result);
        }
        catch (Exception e) {
            LOGGER.debug("NACK (requeue) - unhandled exception", e);
            this.context.log(Activity.level((Severity)Severity.WARNING).tag("Message").message("NACK (requeue) - failed to correlate event"));
            this.getChannel().basicReject(envelope.getDeliveryTag(), true);
        }
    }

    private void handleCorrelationResult(Envelope envelope, CorrelationResult result) throws IOException {
        CorrelationResult correlationResult = result;
        Objects.requireNonNull(correlationResult);
        CorrelationResult correlationResult2 = correlationResult;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CorrelationResult.Success.class, CorrelationResult.Failure.class}, (Object)correlationResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                CorrelationResult.Success ignored = (CorrelationResult.Success)correlationResult2;
                LOGGER.debug("ACK - message correlated successfully");
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
                break;
            }
            case 1: {
                CorrelationResult.Failure failure = (CorrelationResult.Failure)correlationResult2;
                this.context.log(Activity.level((Severity)Severity.WARNING).tag("Message").message("Failed to handle AMQP message with delivery tag " + envelope.getDeliveryTag() + ", reason: " + failure.message()));
                CorrelationFailureHandlingStrategy correlationFailureHandlingStrategy = failure.handlingStrategy();
                Objects.requireNonNull(correlationFailureHandlingStrategy);
                CorrelationFailureHandlingStrategy correlationFailureHandlingStrategy2 = correlationFailureHandlingStrategy;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CorrelationFailureHandlingStrategy.ForwardErrorToUpstream.class, CorrelationFailureHandlingStrategy.Ignore.class}, (Object)correlationFailureHandlingStrategy2, n2)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        CorrelationFailureHandlingStrategy.ForwardErrorToUpstream fwdStrategy = (CorrelationFailureHandlingStrategy.ForwardErrorToUpstream)correlationFailureHandlingStrategy2;
                        if (fwdStrategy.isRetryable()) {
                            LOGGER.debug("NACK (requeue) - message not correlated");
                            this.getChannel().basicReject(envelope.getDeliveryTag(), true);
                            break block0;
                        }
                        LOGGER.debug("NACK (drop) - message not correlated");
                        this.getChannel().basicReject(envelope.getDeliveryTag(), false);
                        break block0;
                    }
                    case 1: 
                }
                CorrelationFailureHandlingStrategy.Ignore ignored = (CorrelationFailureHandlingStrategy.Ignore)correlationFailureHandlingStrategy2;
                LOGGER.debug("ACK - message ignored");
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            }
        }
    }

    @Override
    public void handleCancel(String consumerTag) {
        LOGGER.info("Consumer cancelled: {}", (Object)consumerTag);
        try {
            this.context.log(Activity.level((Severity)Severity.INFO).tag("Subscription").message("Consumer cancelled: " + consumerTag));
            this.context.cancel(null);
        }
        catch (Exception e) {
            this.context.reportHealth(Health.down((Throwable)e));
            LOGGER.error("Failed to cancel Connector execution: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        LOGGER.error("Consumer shutdown: {}", (Object)consumerTag, (Object)sig);
        this.context.log(Activity.level((Severity)Severity.INFO).tag("Subscription").message("Consumer shutdown: " + consumerTag + String.valueOf(sig)));
        try {
            this.context.cancel((Throwable)sig);
        }
        catch (Exception e) {
            LOGGER.error("Failed to cancel Connector execution: {}", (Object)e.getMessage());
        }
    }

    private RabbitMqInboundResult prepareVariables(String consumerTag, AMQP.BasicProperties rawProperties, byte[] body) {
        try {
            ValueNode bodyAsPrimitive;
            JsonNode bodyAsJsonElement;
            String bodyAsString = new String(body, StandardCharsets.UTF_8);
            Object bodyAsObject = this.isPayloadJson(bodyAsString) ? ((bodyAsJsonElement = ObjectMapperSupplier.instance().readValue(StringEscapeUtils.unescapeJson(bodyAsString), JsonNode.class)) instanceof ValueNode ? ((bodyAsPrimitive = (ValueNode)bodyAsJsonElement).isBoolean() ? Boolean.valueOf(bodyAsPrimitive.asBoolean()) : (bodyAsPrimitive.isNumber() ? Double.valueOf(bodyAsPrimitive.asDouble()) : bodyAsPrimitive.asText())) : ObjectMapperSupplier.instance().convertValue((Object)bodyAsJsonElement, Object.class)) : bodyAsString;
            RabbitMqInboundResult.RabbitMqInboundMessage message = new RabbitMqInboundResult.RabbitMqInboundMessage(consumerTag, bodyAsObject, AMQPPropertyUtil.toProperties(rawProperties));
            return new RabbitMqInboundResult(message);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse AMQP message body: {}", (Object)e.getMessage());
            throw new ConnectorInputException((Throwable)e);
        }
    }

    private boolean isPayloadJson(String bodyAsString) {
        try {
            ObjectMapperSupplier.instance().readValue(StringEscapeUtils.unescapeJson(bodyAsString), JsonNode.class);
        }
        catch (JsonProcessingException e) {
            return false;
        }
        return true;
    }
}

