/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.inbound;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import io.camunda.connector.rabbitmq.inbound.model.RabbitMqMessageProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPPropertyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AMQPPropertyUtil.class);

    public static RabbitMqMessageProperties toProperties(AMQP.BasicProperties properties) {
        return new RabbitMqMessageProperties(properties.getContentType(), properties.getContentEncoding(), AMQPPropertyUtil.parseHeaders(properties.getHeaders()), properties.getDeliveryMode(), properties.getPriority(), properties.getCorrelationId(), properties.getReplyTo(), properties.getExpiration(), properties.getMessageId(), properties.getTimestamp(), properties.getType(), properties.getUserId(), properties.getAppId(), properties.getClusterId());
    }

    private static Map<String, Object> parseHeaders(Map<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, Object> processedHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            processedHeaders.put(entry.getKey(), AMQPPropertyUtil.handleHeaderValue(entry.getValue()));
        }
        return processedHeaders;
    }

    private static Object handleHeaderValue(Object value) {
        if (value instanceof LongString) {
            LongString longString = (LongString)value;
            return longString.toString();
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.stream().map(AMQPPropertyUtil::handleHeaderValue).toList();
        }
        LOG.debug("Unhandled header value type: {}. Original value will be returned", (Object)value.getClass());
        return value;
    }
}

