/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import connector.com.fasterxml.jackson.annotation.JsonIgnore;
import connector.com.fasterxml.jackson.annotation.JsonInclude;
import io.camunda.connector.generator.dsl.CommonProperties;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record PropertyGroup(String id, String label, @JsonIgnore List<Property> properties, String tooltip, Boolean openByDefault) {
    public static PropertyGroup OUTPUT_GROUP_OUTBOUND = PropertyGroup.builder().id("output").label("Output mapping").properties(CommonProperties.resultVariable().binding(new PropertyBinding.ZeebeTaskHeader("resultVariable")).build(), CommonProperties.resultExpression().binding(new PropertyBinding.ZeebeTaskHeader("resultExpression")).build()).build();
    public static PropertyGroup OUTPUT_GROUP_INBOUND = PropertyGroup.builder().id("output").label("Output mapping").properties(CommonProperties.resultVariable().binding(new PropertyBinding.ZeebeProperty("resultVariable")).build(), CommonProperties.resultExpression().binding(new PropertyBinding.ZeebeProperty("resultExpression")).build()).build();
    public static PropertyGroup ERROR_GROUP = PropertyGroup.builder().id("error").label("Error handling").properties(CommonProperties.errorExpression().binding(new PropertyBinding.ZeebeTaskHeader("errorExpression")).build()).build();
    public static PropertyGroup RETRIES_GROUP = PropertyGroup.builder().id("retries").label("Retries").properties(CommonProperties.retryCount().binding(PropertyBinding.ZeebeTaskDefinition.RETRIES).build(), CommonProperties.retryBackoff().binding(new PropertyBinding.ZeebeTaskHeader("retryBackoff")).build()).build();
    public static PropertyGroup ACTIVATION_GROUP = PropertyGroup.builder().id("activation").label("Activation").properties(CommonProperties.activationCondition().binding(new PropertyBinding.ZeebeProperty("activationCondition")).build()).build();
    public static PropertyGroup ACTIVATION_GROUP_WITH_CONSUME_UNMATCHED_EVENTS = PropertyGroup.builder().id("activation").label("Activation").properties(CommonProperties.activationCondition().binding(new PropertyBinding.ZeebeProperty("activationCondition")).build(), CommonProperties.consumeUnmatchedEvents().binding(new PropertyBinding.ZeebeProperty("consumeUnmatchedEvents")).build()).build();
    public static PropertyGroup CORRELATION_GROUP_MESSAGE_START_EVENT = PropertyGroup.builder().id("correlation").label("Correlation").tooltip("Learn more about message correlation in the <a href=\"https://docs.camunda.io/docs/components/concepts/messages/#message-correlation-overview\">documentation</a>.").properties(CommonProperties.correlationRequiredDropdown().build(), CommonProperties.correlationKeyProcess().condition(new PropertyCondition.Equals(CommonProperties.correlationRequiredDropdown().id, "required")).build(), CommonProperties.correlationKeyPayload().condition(new PropertyCondition.Equals(CommonProperties.correlationRequiredDropdown().id, "required")).build(), CommonProperties.messageTtl().build(), CommonProperties.messageIdExpression().build(), CommonProperties.messageNameUuidHidden().build()).build();
    public static PropertyGroup CORRELATION_GROUP_INTERMEDIATE_CATCH_EVENT_OR_BOUNDARY = PropertyGroup.builder().id("correlation").label("Correlation").tooltip("Learn more about message correlation in the <a href=\"https://docs.camunda.io/docs/components/concepts/messages/#message-correlation-overview\">documentation</a>.").properties(CommonProperties.correlationKeyProcess().build(), CommonProperties.correlationKeyPayload().build(), CommonProperties.messageIdExpression().build(), CommonProperties.messageTtl().build(), CommonProperties.messageNameUuidHidden().build()).build();
    public static PropertyGroup DEDUPLICATION_GROUP = PropertyGroup.builder().id("deduplication").label("Deduplication").tooltip("Deduplication allows you to configure multiple inbound connector elements to reuse the same backend (consumer/thread/endpoint) by sharing the same deduplication ID.").properties(CommonProperties.deduplicationModeManualFlag().build(), CommonProperties.deduplicationId().build(), CommonProperties.deduplicationModeManual().build(), CommonProperties.deduplicationModeAuto().build()).build();

    public PropertyGroup {
        if (id == null) {
            throw new IllegalArgumentException("id is required");
        }
        if (label == null) {
            throw new IllegalArgumentException("label is required");
        }
        if (properties == null) {
            properties = Collections.emptyList();
        }
    }

    public static PropertyGroupBuilder builder() {
        return new PropertyGroupBuilder();
    }

    public static final class PropertyGroupBuilder {
        private String id;
        private String label;
        private String tooltip;
        private Boolean openByDefault;
        private final List<Property> properties = new ArrayList<Property>();

        private PropertyGroupBuilder() {
        }

        public PropertyGroupBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PropertyGroupBuilder label(String label) {
            this.label = label;
            return this;
        }

        public PropertyGroupBuilder tooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public PropertyGroupBuilder openByDefault(Boolean openByDefault) {
            this.openByDefault = openByDefault;
            return this;
        }

        public PropertyGroupBuilder properties(PropertyBuilder ... properties) {
            this.requireIdSet();
            this.properties.addAll(Stream.of(properties).map(builder -> builder.group(this.id)).map(PropertyBuilder::build).toList());
            return this;
        }

        public PropertyGroupBuilder properties(List<Property> properties) {
            this.requireIdSet();
            properties.forEach(property -> {
                if (!this.id.equals(property.group)) {
                    throw new IllegalArgumentException("Property " + property.id + " defines a different group " + property.group + " than the group " + this.id + " it is added to");
                }
            });
            this.properties.addAll(properties);
            return this;
        }

        public PropertyGroupBuilder properties(Property ... properties) {
            return this.properties(List.of(properties));
        }

        public PropertyGroup build() {
            return new PropertyGroup(this.id, this.label, this.properties, this.tooltip, this.openByDefault);
        }

        private void requireIdSet() {
            if (this.id == null) {
                throw new IllegalStateException("id is required before properties can be set");
            }
        }
    }
}

