/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import io.camunda.connector.generator.dsl.BpmnType;
import io.camunda.connector.generator.dsl.ElementTemplate;
import io.camunda.connector.generator.dsl.ElementTemplateIcon;
import io.camunda.connector.generator.dsl.HiddenProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyGroup;
import io.camunda.connector.generator.dsl.StringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ElementTemplateBuilder {
    private final Mode mode;
    protected String id;
    protected String name;
    protected int version;
    protected ElementTemplateIcon icon;
    protected String documentationRef;
    protected String description;
    protected Set<String> appliesTo;
    protected BpmnType elementType;
    protected final List<PropertyGroup> groups = new ArrayList<PropertyGroup>();
    protected final List<Property> properties = new ArrayList<Property>();

    private ElementTemplateBuilder(Mode mode) {
        this.mode = mode;
    }

    public static ElementTemplateBuilder createOutbound() {
        return new ElementTemplateBuilder(Mode.OUTBOUND);
    }

    public static ElementTemplateBuilder createInbound() {
        return new ElementTemplateBuilder(Mode.INBOUND);
    }

    protected boolean isTypeAssigned() {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.properties.stream().anyMatch(property -> property.binding.equals(PropertyBinding.ZeebeProperty.TYPE));
            case 1 -> this.properties.stream().anyMatch(property -> property.binding.equals(PropertyBinding.ZeebeTaskDefinition.TYPE));
        };
    }

    public ElementTemplateBuilder type(String type) {
        return this.type(type, false);
    }

    public ElementTemplateBuilder type(String type, boolean configurable) {
        this.properties.add(switch (this.mode.ordinal()) {
            case 0 -> {
                if (configurable) {
                    this.groups.addFirst(PropertyGroup.builder().id("connectorType").label("Connector type").build());
                    yield StringProperty.builder().binding(PropertyBinding.ZeebeProperty.TYPE).value(type).id("connectorType").group("connectorType").feel(Property.FeelMode.disabled).build();
                }
                yield HiddenProperty.builder().binding(PropertyBinding.ZeebeProperty.TYPE).value(type).build();
            }
            case 1 -> {
                if (configurable) {
                    this.groups.addFirst(PropertyGroup.builder().id("taskDefinitionType").label("Task definition type").build());
                    yield StringProperty.builder().binding(PropertyBinding.ZeebeTaskDefinition.TYPE).value(type).id("taskDefinitionType").group("taskDefinitionType").feel(Property.FeelMode.disabled).build();
                }
                yield HiddenProperty.builder().binding(PropertyBinding.ZeebeTaskDefinition.TYPE).value(type).build();
            }
            default -> throw new IllegalStateException("Unexpected builder mode value: " + String.valueOf((Object)this.mode));
        });
        return this;
    }

    public ElementTemplateBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ElementTemplateBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ElementTemplateBuilder version(int version) {
        this.version = version;
        return this;
    }

    public ElementTemplateBuilder icon(ElementTemplateIcon icon) {
        this.icon = icon;
        return this;
    }

    public ElementTemplateBuilder documentationRef(String documentationRef) {
        this.documentationRef = documentationRef;
        return this;
    }

    public ElementTemplateBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ElementTemplateBuilder appliesTo(Set<BpmnType> appliesTo) {
        this.appliesTo = appliesTo.stream().map(BpmnType::getName).collect(Collectors.toSet());
        return this;
    }

    public ElementTemplateBuilder appliesTo(BpmnType ... appliesTo) {
        this.appliesTo = Arrays.stream(appliesTo).map(BpmnType::getName).collect(Collectors.toSet());
        return this;
    }

    public ElementTemplateBuilder elementType(BpmnType elementType) {
        this.elementType = elementType;
        return this;
    }

    public ElementTemplateBuilder propertyGroups(PropertyGroup ... groups) {
        this.groups.addAll(Arrays.asList(groups));
        this.properties.addAll(Arrays.stream(groups).flatMap(group -> group.properties().stream()).toList());
        return this;
    }

    public ElementTemplateBuilder propertyGroups(Collection<PropertyGroup> groups) {
        this.groups.addAll(groups);
        this.properties.addAll(groups.stream().flatMap(group -> group.properties().stream()).toList());
        return this;
    }

    public ElementTemplateBuilder properties(Property ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        return this;
    }

    public ElementTemplateBuilder properties(Collection<Property> properties) {
        this.properties.addAll(properties);
        return this;
    }

    public ElementTemplate build() {
        if (!this.isTypeAssigned()) {
            throw new IllegalStateException("type is not assigned");
        }
        return new ElementTemplate(this.id, this.name, this.version, this.documentationRef, this.description, this.appliesTo, ElementTemplate.ElementTypeWrapper.from(this.elementType), this.groups, this.properties, this.icon);
    }

    private static enum Mode {
        INBOUND,
        OUTBOUND;

    }
}

