/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import io.camunda.connector.generator.dsl.BooleanProperty;
import io.camunda.connector.generator.dsl.DropdownProperty;
import io.camunda.connector.generator.dsl.HiddenProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyCondition;
import io.camunda.connector.generator.dsl.PropertyConstraints;
import io.camunda.connector.generator.dsl.StringProperty;
import io.camunda.connector.generator.dsl.TextProperty;
import java.util.List;

public class CommonProperties {
    public static PropertyBuilder resultExpression() {
        return TextProperty.builder().id("resultExpression").group("output").label("Result expression").description("Expression to map the response into process variables").feel(Property.FeelMode.required);
    }

    public static PropertyBuilder resultVariable() {
        return StringProperty.builder().id("resultVariable").group("output").label("Result variable").description("Name of variable to store the response in").feel(Property.FeelMode.disabled);
    }

    public static PropertyBuilder errorExpression() {
        return TextProperty.builder().id("errorExpression").label("Error expression").group("error").description("Expression to handle errors. Details in the <a href=\"https://docs.camunda.io/docs/components/connectors/use-connectors/\" target=\"_blank\">documentation</a>.").feel(Property.FeelMode.required);
    }

    public static PropertyBuilder retryCount() {
        return StringProperty.builder().id("retryCount").label("Retries").description("Number of retries").group("retries").value("3");
    }

    public static PropertyBuilder retryBackoff() {
        return StringProperty.builder().id("retryBackoff").label("Retry backoff").description("ISO-8601 duration to wait between retries").group("retries").value("PT0S");
    }

    public static PropertyBuilder activationCondition() {
        return StringProperty.builder().id("activationCondition").label("Activation condition").description("Condition under which the Connector triggers. Leave empty to catch all events").group("activation").feel(Property.FeelMode.required).optional(true).binding(new PropertyBinding.ZeebeProperty("activationCondition"));
    }

    public static PropertyBuilder consumeUnmatchedEvents() {
        return BooleanProperty.builder().id("consumeUnmatchedEvents").label("Consume unmatched events").tooltip("Unmatched events are rejected by default, allowing the upstream service to handle the error. Check this box to consume unmatched events and return a success response").group("activation").value(false).binding(new PropertyBinding.ZeebeProperty("consumeUnmatchedEvents"));
    }

    public static PropertyBuilder correlationKeyProcess() {
        return StringProperty.builder().id("correlationKeyProcess").label("Correlation key (process)").description("Sets up the correlation key from process variables").group("correlation").feel(Property.FeelMode.required).binding(PropertyBinding.ZeebeSubscriptionProperty.CORRELATION_KEY).constraints(PropertyConstraints.builder().notEmpty(true).build());
    }

    public static PropertyBuilder correlationKeyPayload() {
        return StringProperty.builder().id("correlationKeyPayload").label("Correlation key (payload)").description("Extracts the correlation key from the incoming message payload").group("correlation").feel(Property.FeelMode.required).binding(new PropertyBinding.ZeebeProperty("correlationKeyExpression")).constraints(PropertyConstraints.builder().notEmpty(true).build());
    }

    public static PropertyBuilder messageIdExpression() {
        return StringProperty.builder().id("messageIdExpression").label("Message ID expression").description("Expression to extract unique identifier of a message").group("correlation").feel(Property.FeelMode.required).optional(true).binding(new PropertyBinding.ZeebeProperty("messageIdExpression"));
    }

    public static PropertyBuilder messageTtl() {
        return StringProperty.builder().id("messageTtl").label("Message TTL").description("Time-to-live for the message in the broker (ISO-8601 duration)").group("correlation").optional(false).value("PT0S").constraints(PropertyConstraints.builder().notEmpty(true).pattern(new PropertyConstraints.Pattern("P.*", "must be an ISO-8601 duration")).build()).binding(new PropertyBinding.ZeebeProperty("messageTtl"));
    }

    public static PropertyBuilder messageNameUuidHidden() {
        return HiddenProperty.builder().id("messageNameUuid").group("correlation").generatedValue().binding(PropertyBinding.MessageProperty.NAME);
    }

    public static PropertyBuilder correlationRequiredDropdown() {
        return DropdownProperty.builder().choices(List.of(new DropdownProperty.DropdownChoice("Correlation not required", "notRequired"), new DropdownProperty.DropdownChoice("Correlation required", "required"))).id("correlationRequired").label("Subprocess correlation required").description("Indicates whether correlation is required. This is needed for event-based subprocess message start events").group("correlation").value("notRequired").binding(new PropertyBinding.ZeebeProperty("correlationRequired"));
    }

    public static PropertyBuilder deduplicationModeManualFlag() {
        return BooleanProperty.builder().id("deduplicationModeManualFlag").label("Manual mode").group("deduplication").description("By default, similar connectors receive the same deduplication ID. Customize by activating manual mode").value(false).binding(new PropertyBinding.ZeebeProperty("deduplicationModeManualFlag"));
    }

    public static PropertyBuilder deduplicationId() {
        return StringProperty.builder().id("deduplicationId").label("Deduplication ID").group("deduplication").feel(Property.FeelMode.disabled).binding(new PropertyBinding.ZeebeProperty("deduplicationId")).constraints(PropertyConstraints.builder().notEmpty(true).pattern(new PropertyConstraints.Pattern("^[a-zA-Z0-9_-]+$", "can only contain alphanumeric characters, dashes, and underscores")).build()).condition(new PropertyCondition.Equals("deduplicationModeManualFlag", true));
    }

    public static PropertyBuilder deduplicationModeManual() {
        return HiddenProperty.builder().id("deduplicationModeManual").group("deduplication").value("MANUAL").condition(new PropertyCondition.IsActive("deduplicationId", true)).binding(new PropertyBinding.ZeebeProperty("deduplicationMode"));
    }

    public static PropertyBuilder deduplicationModeAuto() {
        return HiddenProperty.builder().id("deduplicationModeAuto").group("deduplication").value("AUTO").condition(new PropertyCondition.IsActive("deduplicationId", false)).binding(new PropertyBinding.ZeebeProperty("deduplicationMode"));
    }
}

