/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.supplier;

import com.rabbitmq.client.ConnectionFactory;
import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthentication;
import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthenticationType;
import io.camunda.connector.rabbitmq.common.model.RabbitMqRouting;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

public class ConnectionFactorySupplier {
    public ConnectionFactory createFactory(RabbitMqAuthentication authentication, RabbitMqRouting routing) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        ConnectionFactory factory = new ConnectionFactory();
        if (authentication.getAuthType() == RabbitMqAuthenticationType.uri) {
            factory.setUri(authentication.getUri());
        } else {
            factory.setUsername(authentication.getUserName());
            factory.setPassword(authentication.getPassword());
            factory.setVirtualHost(routing.getVirtualHost());
            factory.setHost(routing.getHostName());
            factory.setPort(Integer.parseInt(routing.getPort()));
        }
        return factory;
    }
}

