/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound.model;

import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthentication;
import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthenticationType;
import io.camunda.connector.rabbitmq.common.model.RabbitMqMessage;
import io.camunda.connector.rabbitmq.outbound.model.RabbitMqOutboundRouting;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

public class RabbitMqRequest {
    @Valid
    @NotNull
    private RabbitMqAuthentication authentication;
    @Valid
    @NotNull
    private RabbitMqOutboundRouting routing;
    @Valid
    @NotNull
    private RabbitMqMessage message;

    @AssertFalse
    private boolean isRoutingParamsNotFilling() {
        if (this.authentication.getAuthType() == RabbitMqAuthenticationType.uri) {
            return false;
        }
        if (this.authentication.getAuthType() == RabbitMqAuthenticationType.credentials && this.routing != null) {
            return this.routing.getPort() == null || this.routing.getPort().isBlank() || this.routing.getHostName() == null || this.routing.getHostName().isBlank() || this.routing.getVirtualHost() == null || this.routing.getVirtualHost().isBlank();
        }
        return true;
    }

    public RabbitMqAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(RabbitMqAuthentication authentication) {
        this.authentication = authentication;
    }

    public RabbitMqOutboundRouting getRouting() {
        return this.routing;
    }

    public void setRouting(RabbitMqOutboundRouting routing) {
        this.routing = routing;
    }

    public RabbitMqMessage getMessage() {
        return this.message;
    }

    public void setMessage(RabbitMqMessage message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMqRequest request = (RabbitMqRequest)o;
        return Objects.equals(this.authentication, request.authentication) && Objects.equals(this.routing, request.routing) && Objects.equals(this.message, request.message);
    }

    public int hashCode() {
        return Objects.hash(this.authentication, this.routing, this.message);
    }

    public String toString() {
        return "RabbitMqRequest{authentication=" + this.authentication + ", routing=" + this.routing + ", message=" + this.message + "}";
    }
}

