/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound.model;

import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.rabbitmq.common.model.RabbitMqRouting;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;

public class RabbitMqOutboundRouting
extends RabbitMqRouting {
    @NotBlank
    @Secret
    private String exchange;
    @NotBlank
    @Secret
    private String routingKey;

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMqOutboundRouting routing = (RabbitMqOutboundRouting)o;
        return Objects.equals(this.virtualHost, routing.virtualHost) && Objects.equals(this.hostName, routing.hostName) && Objects.equals(this.port, routing.port) && Objects.equals(this.exchange, routing.exchange) && Objects.equals(this.routingKey, routing.routingKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.virtualHost, this.hostName, this.port, this.exchange, this.routingKey);
    }

    @Override
    public String toString() {
        return "RabbitMqRouting{virtualHost='" + this.virtualHost + "', hostName='" + this.hostName + "', port='" + this.port + "', exchange='" + this.exchange + "', routingKey='" + this.routingKey + "'}";
    }
}

