/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.outbound;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.rabbitmq.outbound.RabbitMqResult;
import io.camunda.connector.rabbitmq.outbound.model.RabbitMqRequest;
import io.camunda.connector.rabbitmq.supplier.ConnectionFactorySupplier;

@OutboundConnector(name="RABBITMQ_OUTBOUND", inputVariables={"authentication", "routing", "message"}, type="io.camunda:connector-rabbitmq:1")
public class RabbitMqFunction
implements OutboundConnectorFunction {
    private final ConnectionFactorySupplier connectionFactorySupplier;

    public RabbitMqFunction() {
        this.connectionFactorySupplier = new ConnectionFactorySupplier();
    }

    public RabbitMqFunction(ConnectionFactorySupplier connectionFactorySupplier) {
        this.connectionFactorySupplier = connectionFactorySupplier;
    }

    public Object execute(OutboundConnectorContext context) throws Exception {
        RabbitMqRequest request = (RabbitMqRequest)context.bindVariables(RabbitMqRequest.class);
        return this.executeConnector(request);
    }

    private RabbitMqResult executeConnector(RabbitMqRequest request) throws Exception {
        AMQP.BasicProperties messageProperties = request.getMessage().getPropertiesAsAmqpBasicProperties();
        byte[] messageInByteArray = request.getMessage().getBodyAsByteArray();
        try (Connection connection = this.openConnection(request);){
            Channel channel = connection.createChannel();
            channel.basicPublish(request.getRouting().getExchange(), request.getRouting().getRoutingKey(), messageProperties, messageInByteArray);
            RabbitMqResult rabbitMqResult = RabbitMqResult.success();
            return rabbitMqResult;
        }
    }

    private Connection openConnection(RabbitMqRequest request) throws Exception {
        return this.connectionFactorySupplier.createFactory(request.getAuthentication(), request.getRouting()).newConnection();
    }
}

