/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.inbound.model;

import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthentication;
import io.camunda.connector.rabbitmq.common.model.RabbitMqRouting;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import java.util.Objects;

public class RabbitMqInboundProperties {
    @Valid
    @NotNull
    @Secret
    private RabbitMqAuthentication authentication;
    @Valid
    @Secret
    private RabbitMqRouting routing;
    @Secret
    @NotBlank
    private String queueName;
    @Secret
    private String consumerTag;
    @Valid
    @Secret
    private Map<String, Object> arguments;
    private boolean exclusive;

    public RabbitMqAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(RabbitMqAuthentication authentication) {
        this.authentication = authentication;
    }

    public RabbitMqRouting getRouting() {
        return this.routing;
    }

    public void setRouting(RabbitMqRouting routing) {
        this.routing = routing;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public void setConsumerTag(String consumerTag) {
        this.consumerTag = consumerTag;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMqInboundProperties that = (RabbitMqInboundProperties)o;
        return this.exclusive == that.exclusive && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.routing, that.routing) && Objects.equals(this.queueName, that.queueName) && Objects.equals(this.consumerTag, that.consumerTag) && Objects.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.authentication, this.routing, this.queueName, this.consumerTag, this.arguments, this.exclusive);
    }

    public String toString() {
        return "RabbitMqInboundProperties{authentication=" + this.authentication + ", routing=" + this.routing + ", queueName='" + this.queueName + "', consumerTag='" + this.consumerTag + "', arguments=" + this.arguments + ", exclusive=" + this.exclusive + "}";
    }
}

