/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.inbound;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import io.camunda.connector.api.error.ConnectorInputException;
import io.camunda.connector.api.inbound.Health;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.api.inbound.InboundConnectorResult;
import io.camunda.connector.rabbitmq.inbound.AMQPPropertyUtil;
import io.camunda.connector.rabbitmq.inbound.model.RabbitMqInboundResult;
import io.camunda.connector.rabbitmq.supplier.GsonSupplier;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMqConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqConsumer.class);
    private final InboundConnectorContext context;

    public RabbitMqConsumer(Channel channel, InboundConnectorContext context) {
        super(channel);
        this.context = context;
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        LOGGER.debug("Received AMQP message with delivery tag {}", (Object)envelope.getDeliveryTag());
        try {
            RabbitMqInboundResult variables = this.prepareVariables(consumerTag, properties, body);
            InboundConnectorResult result = this.context.correlate((Object)variables);
            if (result != null && result.isActivated()) {
                LOGGER.debug("ACK - inbound event correlated successfully: {}", (Object)result.getResponseData());
                this.getChannel().basicAck(envelope.getDeliveryTag(), false);
            } else if (result != null) {
                LOGGER.debug("NACK (no requeue) - inbound event not correlated: {}", (Object)result.getErrorData());
                this.getChannel().basicReject(envelope.getDeliveryTag(), false);
            } else {
                LOGGER.error("NACK (requeue) - no response from correlation");
                this.getChannel().basicReject(envelope.getDeliveryTag(), true);
            }
        }
        catch (ConnectorInputException e) {
            LOGGER.warn("NACK (no requeue) - failed to parse AMQP message body: {}", (Object)e.getMessage());
            this.getChannel().basicReject(envelope.getDeliveryTag(), false);
        }
        catch (Exception e) {
            LOGGER.debug("NACK (requeue) - failed to correlate event", e);
            this.getChannel().basicReject(envelope.getDeliveryTag(), true);
        }
    }

    @Override
    public void handleCancel(String consumerTag) {
        LOGGER.info("Consumer cancelled: {}", (Object)consumerTag);
        try {
            this.context.cancel(null);
        }
        catch (Exception e) {
            this.context.reportHealth(Health.down((Throwable)e));
            LOGGER.error("Failed to cancel Connector execution: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        LOGGER.error("Consumer shutdown: {}", (Object)consumerTag, (Object)sig);
        try {
            this.context.cancel((Throwable)sig);
        }
        catch (Exception e) {
            LOGGER.error("Failed to cancel Connector execution: {}", (Object)e.getMessage());
        }
    }

    private RabbitMqInboundResult prepareVariables(String consumerTag, AMQP.BasicProperties rawProperties, byte[] body) {
        try {
            JsonPrimitive bodyAsPrimitive;
            String bodyAsString = new String(body, StandardCharsets.UTF_8);
            JsonElement bodyAsJsonElement = GsonSupplier.gson().fromJson(StringEscapeUtils.unescapeJson(bodyAsString), JsonElement.class);
            Object bodyAsObject = bodyAsJsonElement instanceof JsonPrimitive ? ((bodyAsPrimitive = (JsonPrimitive)bodyAsJsonElement).isBoolean() ? Boolean.valueOf(bodyAsPrimitive.getAsBoolean()) : (bodyAsPrimitive.isNumber() ? bodyAsPrimitive.getAsNumber() : bodyAsPrimitive.getAsString())) : GsonSupplier.gson().fromJson(bodyAsJsonElement, Object.class);
            RabbitMqInboundResult.RabbitMqInboundMessage message = new RabbitMqInboundResult.RabbitMqInboundMessage(consumerTag, bodyAsObject, AMQPPropertyUtil.toProperties(rawProperties));
            return new RabbitMqInboundResult(message);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse AMQP message body: {}", (Object)e.getMessage());
            throw new ConnectorInputException((Throwable)e);
        }
    }
}

