/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.common.model;

import com.rabbitmq.client.AMQP;
import connector.com.fasterxml.jackson.core.JsonProcessingException;
import connector.com.fasterxml.jackson.databind.DeserializationFeature;
import connector.com.fasterxml.jackson.databind.JsonNode;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import connector.com.fasterxml.jackson.databind.SerializationFeature;
import connector.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import connector.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import connector.com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.camunda.connector.rabbitmq.outbound.ValidationPropertiesUtil;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMqMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMqMessage.class);
    private static final ObjectMapper mapper = new ObjectMapper().registerModule(new Jdk8Module()).registerModule(DefaultScalaModule$.MODULE$).registerModule(new JavaTimeModule()).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private Object properties;
    @NotNull
    private Object body;

    public AMQP.BasicProperties getPropertiesAsAmqpBasicProperties() {
        return Optional.ofNullable(this.properties).map(properties -> mapper.convertValue(properties, JsonNode.class)).map(ValidationPropertiesUtil::validateAmqpBasicPropertiesOrThrowException).map(jsonProperties -> mapper.convertValue(jsonProperties, AMQP.BasicProperties.class)).orElse(null);
    }

    public byte[] getBodyAsByteArray() {
        if (this.body instanceof String) {
            try {
                JsonNode jsonElement = mapper.readTree(StringEscapeUtils.unescapeJson(this.body.toString()));
                if (jsonElement.isValueNode()) {
                    return ((String)this.body).getBytes();
                }
                this.body = jsonElement;
            }
            catch (JsonProcessingException e) {
                LOGGER.debug("Expected exception when parsing a plain text value : {}", this.body, (Object)e);
                return this.body.toString().getBytes();
            }
        }
        return Optional.of(this.body).map(body -> {
            try {
                return mapper.writeValueAsString(body);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).map(StringEscapeUtils::unescapeJson).map(String::getBytes).orElseThrow(() -> new RuntimeException("Parse error to byte array"));
    }

    public Object getProperties() {
        return this.properties;
    }

    public void setProperties(Object properties) {
        this.properties = properties;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMqMessage message = (RabbitMqMessage)o;
        return Objects.equals(this.properties, message.properties) && Objects.equals(this.body, message.body);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.body);
    }

    public String toString() {
        return "RabbitMqMessage{properties=" + this.properties + ", body=" + this.body + "}";
    }
}

