/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.rabbitmq.common.model;

import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.rabbitmq.common.model.RabbitMqAuthenticationType;
import jakarta.validation.constraints.AssertFalse;
import java.util.Objects;

public class RabbitMqAuthentication {
    private RabbitMqAuthenticationType authType;
    @Secret
    private String userName;
    @Secret
    private String password;
    @Secret
    private String uri;

    @AssertFalse
    private boolean isAuthFieldsIsEmpty() {
        if (this.authType == RabbitMqAuthenticationType.uri) {
            return this.uri == null || this.uri.isBlank();
        }
        if (this.authType == RabbitMqAuthenticationType.credentials) {
            return this.userName == null || this.userName.isBlank() || this.password == null || this.password.isBlank();
        }
        return true;
    }

    public RabbitMqAuthenticationType getAuthType() {
        return this.authType;
    }

    public void setAuthType(RabbitMqAuthenticationType authType) {
        this.authType = authType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMqAuthentication that = (RabbitMqAuthentication)o;
        return this.authType == that.authType && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authType, this.userName, this.password, this.uri});
    }

    public String toString() {
        return "RabbitMqAuthentication{authType=" + this.authType + "}";
    }
}

