/*
 * Decompiled with CFR 0.152.
 */
package connector.com.fasterxml.jackson.datatype.jsr310.deser;

import connector.com.fasterxml.jackson.annotation.JsonFormat;
import connector.com.fasterxml.jackson.core.JsonParser;
import connector.com.fasterxml.jackson.core.JsonToken;
import connector.com.fasterxml.jackson.core.StreamReadCapability;
import connector.com.fasterxml.jackson.core.io.NumberInput;
import connector.com.fasterxml.jackson.databind.BeanProperty;
import connector.com.fasterxml.jackson.databind.DeserializationContext;
import connector.com.fasterxml.jackson.databind.DeserializationFeature;
import connector.com.fasterxml.jackson.databind.JsonDeserializer;
import connector.com.fasterxml.jackson.databind.JsonMappingException;
import connector.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import connector.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import connector.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import connector.com.fasterxml.jackson.datatype.jsr310.util.DurationUnitConverter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();
    protected final DurationUnitConverter _durationUnitConverter;

    public DurationDeserializer() {
        super(Duration.class);
        this._durationUnitConverter = null;
    }

    protected DurationDeserializer(DurationDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._durationUnitConverter = base._durationUnitConverter;
    }

    protected DurationDeserializer(DurationDeserializer base, DurationUnitConverter converter) {
        super(base, (Boolean)base._isLenient);
        this._durationUnitConverter = converter;
    }

    protected DurationDeserializer withLeniency(Boolean leniency) {
        return new DurationDeserializer(this, leniency);
    }

    protected DurationDeserializer withConverter(DurationUnitConverter converter) {
        return new DurationDeserializer(this, converter);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        DurationDeserializer deser = this;
        if (format != null) {
            Boolean leniency;
            if (format.hasLenient() && (leniency = format.getLenient()) != null) {
                deser = deser.withLeniency(leniency);
            }
            if (format.hasPattern()) {
                String pattern = format.getPattern();
                DurationUnitConverter p = DurationUnitConverter.from(pattern);
                if (p == null) {
                    ctxt.reportBadDefinition(this.getValueType(ctxt), String.format("Bad 'pattern' definition (\"%s\") for `Duration`: expected one of [%s]", pattern, DurationUnitConverter.descForAllowed()));
                }
                deser = deser.withConverter(p);
            }
        }
        return deser;
    }

    @Override
    public Duration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        switch (parser.currentTokenId()) {
            case 8: {
                BigDecimal value = parser.getDecimalValue();
                return DecimalUtils.extractSecondsAndNanos(value, Duration::ofSeconds);
            }
            case 7: {
                return this._fromTimestamp(context, parser.getLongValue());
            }
            case 6: {
                return this._fromString(parser, context, parser.getText());
            }
            case 1: {
                return this._fromString(parser, context, context.extractScalarFromObject(parser, this, this.handledType()));
            }
            case 12: {
                return (Duration)parser.getEmbeddedObject();
            }
            case 3: {
                return (Duration)this._deserializeFromArray(parser, context);
            }
        }
        return (Duration)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT, JsonToken.VALUE_NUMBER_FLOAT);
    }

    protected Duration _fromString(JsonParser parser, DeserializationContext ctxt, String value0) throws IOException {
        String value = value0.trim();
        if (value.length() == 0) {
            return (Duration)this._fromEmptyString(parser, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong(value));
        }
        try {
            return Duration.parse(value);
        }
        catch (DateTimeException e) {
            return (Duration)this._handleDateTimeException(ctxt, e, value);
        }
    }

    protected Duration _fromTimestamp(DeserializationContext ctxt, long ts) {
        if (this._durationUnitConverter != null) {
            return this._durationUnitConverter.convert(ts);
        }
        if (ctxt.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return Duration.ofSeconds(ts);
        }
        return Duration.ofMillis(ts);
    }
}

