/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.polling.task;

import io.camunda.connector.api.inbound.Activity;
import io.camunda.connector.api.inbound.InboundIntermediateConnectorContext;
import io.camunda.connector.api.inbound.ProcessInstanceContext;
import io.camunda.connector.api.inbound.Severity;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import io.camunda.connector.http.base.model.HttpCommonResult;
import io.camunda.connector.http.base.services.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestTask.class);
    private final HttpService httpService;
    private final ProcessInstanceContext processInstanceContext;
    private final InboundIntermediateConnectorContext context;

    public HttpRequestTask(HttpService httpService, ProcessInstanceContext processInstanceContext, InboundIntermediateConnectorContext context) {
        this.httpService = httpService;
        this.processInstanceContext = processInstanceContext;
        this.context = context;
    }

    @Override
    public void run() {
        try {
            HttpCommonRequest httpRequest = (HttpCommonRequest)this.processInstanceContext.bind(HttpCommonRequest.class);
            if (httpRequest != null) {
                try {
                    HttpCommonResult httpResponse = this.httpService.executeConnectorRequest(httpRequest);
                    this.processInstanceContext.correlate((Object)httpResponse);
                    this.context.log(Activity.level((Severity)Severity.INFO).tag(httpRequest.getMethod().toString()).message("Polled url: " + httpRequest.getUrl()));
                }
                catch (Exception e) {
                    LOGGER.warn("Exception encountered while executing HTTP request for process instance {}: {}", (Object)this.processInstanceContext, (Object)e.getMessage());
                }
            } else {
                LOGGER.debug("No HTTP request binding found for process instance {}", (Object)this.processInstanceContext);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred while binding properties for processInstanceKey {}: {}", (Object)this.processInstanceContext.getKey(), (Object)e.getMessage());
            this.context.log(Activity.level((Severity)Severity.ERROR).tag("error").message("Error occurred while binding properties"));
        }
    }
}

