/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.rest;

import com.google.api.client.http.HttpRequestFactory;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.json.ConnectorsObjectMapperSupplier;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.generator.java.annotation.ElementTemplate;
import io.camunda.connector.http.base.components.HttpTransportComponentSupplier;
import io.camunda.connector.http.base.services.HttpService;
import io.camunda.connector.http.rest.model.HttpJsonRequest;
import java.io.IOException;

@OutboundConnector(name="HTTP REST", inputVariables={"url", "method", "authentication", "headers", "queryParameters", "connectionTimeoutInSeconds", "readTimeoutInSeconds", "writeTimeoutInSeconds", "body"}, type="io.camunda:http-json:1")
@ElementTemplate(id="io.camunda.connectors.HttpJson.v2", name="REST Outbound Connector", description="Invoke REST API", inputDataClass=HttpJsonRequest.class, version=7, propertyGroups={@ElementTemplate.PropertyGroup(id="authentication", label="Authentication"), @ElementTemplate.PropertyGroup(id="endpoint", label="HTTP endpoint"), @ElementTemplate.PropertyGroup(id="timeout", label="Connection timeout"), @ElementTemplate.PropertyGroup(id="payload", label="Payload")}, documentationRef="https://docs.camunda.io/docs/components/connectors/protocol/rest/", icon="icon.svg")
public class HttpJsonFunction
implements OutboundConnectorFunction {
    public static final String TYPE = "io.camunda:http-json:1";
    private final HttpService httpService;

    public HttpJsonFunction() {
        this(ConnectorsObjectMapperSupplier.getCopy(), HttpTransportComponentSupplier.httpRequestFactoryInstance());
    }

    public HttpJsonFunction(ObjectMapper objectMapper, HttpRequestFactory requestFactory) {
        this.httpService = new HttpService(objectMapper, requestFactory);
    }

    public Object execute(OutboundConnectorContext context) throws IOException, InstantiationException, IllegalAccessException {
        HttpJsonRequest request = (HttpJsonRequest)context.bindVariables(HttpJsonRequest.class);
        return this.httpService.executeConnectorRequest(request);
    }
}

