/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.utils;

import connector.com.fasterxml.jackson.core.JsonProcessingException;
import connector.com.fasterxml.jackson.databind.JsonNode;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonHelper.class);

    public static JsonNode getAsJsonElement(String strResponse, ObjectMapper mapper) {
        return Optional.ofNullable(strResponse).filter(response -> !response.isBlank()).map(response -> {
            try {
                return mapper.readTree((String)response);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Wasn't able to create a JSON node from string: " + strResponse);
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }
}

