/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.services;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.http.base.auth.OAuthAuthentication;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import io.camunda.connector.http.base.model.HttpCommonResult;
import io.camunda.connector.http.base.services.AuthenticationService;
import io.camunda.connector.http.base.services.HttpInteractionService;
import io.camunda.connector.http.base.services.HttpProxyService;
import io.camunda.connector.http.base.services.HttpRequestMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpService.class);
    private final ObjectMapper objectMapper;
    private final HttpRequestFactory requestFactory;
    private final String proxyFunctionUrl = System.getenv("CAMUNDA_CONNECTOR_HTTP_PROXY_URL");
    private final HttpInteractionService httpInteractionService;

    public HttpService(ObjectMapper objectMapper, HttpRequestFactory requestFactory) {
        this.objectMapper = objectMapper;
        this.requestFactory = requestFactory;
        this.httpInteractionService = new HttpInteractionService(objectMapper);
    }

    public HttpCommonResult executeConnectorRequest(HttpCommonRequest request) throws IOException, InstantiationException, IllegalAccessException {
        return this.proxyFunctionUrl == null ? this.executeRequestDirectly(request) : this.executeRequestViaProxy(request);
    }

    private HttpCommonResult executeRequestDirectly(HttpCommonRequest request) throws IOException, InstantiationException, IllegalAccessException {
        String bearerToken = null;
        HttpInteractionService httpInteractionService = new HttpInteractionService(this.objectMapper);
        if (request.getAuthentication() != null && request.getAuthentication() instanceof OAuthAuthentication) {
            AuthenticationService authService = new AuthenticationService(this.objectMapper, this.requestFactory);
            bearerToken = this.getTokenFromOAuthRequest(request, httpInteractionService, authService);
        }
        HttpRequest httpRequest = HttpRequestMapper.toHttpRequest(this.requestFactory, request, bearerToken);
        HttpResponse httpResponse = httpInteractionService.executeHttpRequest(httpRequest, false);
        return httpInteractionService.toHttpResponse(httpResponse, HttpCommonResult.class);
    }

    private String getTokenFromOAuthRequest(HttpCommonRequest connectorRequest, HttpInteractionService httpInteractionService, AuthenticationService authService) throws IOException {
        HttpRequest oauthRequest = authService.createOAuthRequest(connectorRequest);
        HttpResponse oauthResponse = httpInteractionService.executeHttpRequest(oauthRequest);
        return authService.extractOAuthAccessToken(oauthResponse);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public HttpCommonResult executeRequestViaProxy(HttpCommonRequest request) throws IOException {
        HttpRequest httpRequest = HttpProxyService.toRequestViaProxy(this.requestFactory, request, this.proxyFunctionUrl);
        HttpResponse httpResponse = this.httpInteractionService.executeHttpRequest(httpRequest, true);
        try (InputStream responseContentStream = httpResponse.getContent();){
            HttpCommonResult httpCommonResult;
            try (InputStreamReader reader = new InputStreamReader(responseContentStream);){
                HttpCommonResult jsonResult = this.objectMapper.readValue((Reader)reader, HttpCommonResult.class);
                LOGGER.debug("Proxy returned result: " + String.valueOf(jsonResult));
                httpCommonResult = jsonResult;
            }
            return httpCommonResult;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse external response: {}", (Object)httpResponse, (Object)e);
            throw new ConnectorException("Failed to parse result: " + e.getMessage(), (Throwable)e);
        }
    }
}

