/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.model;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import io.camunda.connector.http.base.model.HttpMethod;
import io.camunda.connector.http.base.utils.Timeout;
import java.io.IOException;

public final class HttpRequestBuilder {
    private HttpMethod method;
    private GenericUrl genericUrl;
    private HttpHeaders headers;
    private HttpContent content;
    private Integer connectionTimeoutInSeconds;
    private Integer readTimeoutInSeconds;
    private Integer writeTimeoutInSeconds;
    private boolean followRedirects;

    public HttpRequestBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder genericUrl(GenericUrl genericUrl) {
        this.genericUrl = genericUrl;
        return this;
    }

    public HttpRequestBuilder headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequestBuilder content(HttpContent content) {
        this.content = content;
        return this;
    }

    public HttpRequestBuilder connectionTimeoutInSeconds(Integer connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
        return this;
    }

    public HttpRequestBuilder readTimeoutInSeconds(Integer readTimeoutInSeconds) {
        this.readTimeoutInSeconds = readTimeoutInSeconds;
        return this;
    }

    public HttpRequestBuilder writeTimeoutInSeconds(Integer writeTimeoutInSeconds) {
        this.writeTimeoutInSeconds = writeTimeoutInSeconds;
        return this;
    }

    public HttpRequestBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpRequest build(HttpRequestFactory requestFactory) throws IOException {
        HttpRequest httpRequest = requestFactory.buildRequest(this.method.name(), this.genericUrl, this.content);
        httpRequest.setFollowRedirects(this.followRedirects);
        if (this.headers != null) {
            httpRequest.setHeaders(this.headers);
        }
        Timeout.copyTimeoutFrom(httpRequest, this.connectionTimeoutInSeconds, this.readTimeoutInSeconds, this.writeTimeoutInSeconds);
        return httpRequest;
    }
}

