/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java.processor;

import io.camunda.connector.generator.dsl.DropdownProperty;
import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyCondition;
import io.camunda.connector.generator.dsl.PropertyConstraints;
import io.camunda.connector.generator.java.annotation.TemplateProperty;
import io.camunda.connector.generator.java.processor.FieldProcessor;
import java.lang.reflect.Field;
import java.util.Arrays;

public class TemplatePropertyFieldProcessor
implements FieldProcessor {
    @Override
    public void process(Field field2, PropertyBuilder builder) {
        TemplateProperty annotation = field2.getAnnotation(TemplateProperty.class);
        if (annotation == null) {
            return;
        }
        builder.optional(FieldProcessor.isOptional(field2));
        if (annotation.feel() != Property.FeelMode.disabled && !(builder instanceof DropdownProperty.DropdownPropertyBuilder)) {
            builder.feel(annotation.feel());
        }
        if (!annotation.label().isBlank()) {
            builder.label(annotation.label());
        }
        if (!annotation.description().isBlank()) {
            builder.description(annotation.description());
        }
        if (!annotation.defaultValue().isBlank()) {
            builder.value(annotation.defaultValue());
        }
        if (!annotation.group().isBlank()) {
            builder.group(annotation.group());
        }
        builder.condition(this.buildCondition(annotation));
        builder.constraints(this.buildConstraints(annotation));
    }

    private PropertyCondition buildCondition(TemplateProperty propertyAnnotation) {
        TemplateProperty.PropertyCondition conditionAnnotation = propertyAnnotation.condition();
        if (conditionAnnotation.property().isBlank()) {
            return null;
        }
        if (conditionAnnotation.equals().isBlank() && conditionAnnotation.oneOf().length == 0) {
            throw new IllegalStateException("InvalidCondition must have either 'equals' or 'oneOf' set");
        }
        return TemplatePropertyFieldProcessor.transformToCondition(conditionAnnotation);
    }

    public static PropertyCondition transformToCondition(TemplateProperty.PropertyCondition conditionAnnotation) {
        if (!conditionAnnotation.equals().isBlank()) {
            return new PropertyCondition.Equals(conditionAnnotation.property(), conditionAnnotation.equals());
        }
        return new PropertyCondition.OneOf(conditionAnnotation.property(), Arrays.asList(conditionAnnotation.oneOf()));
    }

    private PropertyConstraints buildConstraints(TemplateProperty propertyAnnotation) {
        TemplateProperty.PropertyConstraints constraintsAnnotation = propertyAnnotation.constraints();
        if (!constraintsAnnotation.notEmpty() && constraintsAnnotation.maxLength() == Integer.MAX_VALUE && constraintsAnnotation.minLength() == Integer.MIN_VALUE && constraintsAnnotation.pattern().value().isBlank()) {
            return null;
        }
        PropertyConstraints.PropertyConstraintsBuilder builder = PropertyConstraints.builder();
        if (constraintsAnnotation.notEmpty()) {
            builder.notEmpty(true);
        }
        if (constraintsAnnotation.maxLength() != Integer.MAX_VALUE) {
            builder.maxLength(constraintsAnnotation.maxLength());
        }
        if (constraintsAnnotation.minLength() != Integer.MIN_VALUE) {
            builder.minLength(constraintsAnnotation.minLength());
        }
        if (!constraintsAnnotation.pattern().value().isBlank()) {
            if (!constraintsAnnotation.notEmpty() && propertyAnnotation.optional()) {
                builder.notEmpty(false);
            }
            builder.pattern(new PropertyConstraints.Pattern(constraintsAnnotation.pattern().value(), constraintsAnnotation.pattern().message()));
        }
        return builder.build();
    }
}

