/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.java.processor;

import io.camunda.connector.generator.dsl.PropertyBuilder;
import io.camunda.connector.generator.dsl.PropertyConstraints;
import io.camunda.connector.generator.java.processor.FieldProcessor;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.lang.reflect.Field;
import org.apache.commons.lang3.tuple.Pair;

public class JakartaValidationFieldProcessor
implements FieldProcessor {
    @Override
    public void process(Field field2, PropertyBuilder propertyBuilder) {
        PropertyConstraints constraints;
        Pair<String, String> pattern;
        Integer maxSize;
        Integer minSize;
        PropertyConstraints.PropertyConstraintsBuilder constraintsBuilder = PropertyConstraints.builder();
        if (this.hasNotEmptyConstraint(field2)) {
            constraintsBuilder.notEmpty(true);
        }
        if ((minSize = this.hasMinSizeAnnotation(field2)) != null) {
            constraintsBuilder.minLength(minSize);
        }
        if ((maxSize = this.hasMaxSizeAnnotation(field2)) != null) {
            constraintsBuilder.maxLength(maxSize);
        }
        if ((pattern = this.hasPatternAnnotation(field2)) != null) {
            constraintsBuilder.pattern(new PropertyConstraints.Pattern(pattern.getLeft(), pattern.getRight()));
        }
        if (pattern != null && !this.hasNotEmptyConstraint(field2) && FieldProcessor.isOptional(field2)) {
            constraintsBuilder.notEmpty(false);
        }
        if (!this.isConstraintEmpty(constraints = constraintsBuilder.build())) {
            propertyBuilder.constraints(constraints);
        }
    }

    private boolean hasNotEmptyConstraint(Field field2) {
        return field2.isAnnotationPresent(NotBlank.class) || field2.isAnnotationPresent(NotEmpty.class) || field2.isAnnotationPresent(NotNull.class);
    }

    private Integer hasMinSizeAnnotation(Field field2) {
        Size sizeAnnotation = field2.getAnnotation(Size.class);
        if (sizeAnnotation != null && sizeAnnotation.min() != Integer.MIN_VALUE) {
            return sizeAnnotation.min();
        }
        return null;
    }

    private Integer hasMaxSizeAnnotation(Field field2) {
        Size sizeAnnotation = field2.getAnnotation(Size.class);
        if (sizeAnnotation != null && sizeAnnotation.max() != Integer.MAX_VALUE) {
            return sizeAnnotation.max();
        }
        return null;
    }

    private Pair<String, String> hasPatternAnnotation(Field field2) {
        Pattern patternAnnotation = field2.getAnnotation(Pattern.class);
        if (patternAnnotation != null) {
            if (patternAnnotation.message().equals("{jakarta.validation.constraints.Pattern.message}")) {
                return Pair.of(patternAnnotation.regexp(), null);
            }
            return Pair.of(patternAnnotation.regexp(), patternAnnotation.message());
        }
        return null;
    }

    private boolean isConstraintEmpty(PropertyConstraints constraints) {
        return constraints.pattern() == null && constraints.minLength() == null && constraints.maxLength() == null && constraints.notEmpty() == null;
    }
}

