/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;

public record ElementTemplateIcon(String contents) {
    public static ElementTemplateIcon from(String location, ClassLoader classLoader) {
        if (location.startsWith("https://")) {
            return new ElementTemplateIcon(location);
        }
        try {
            return new ElementTemplateIcon(ElementTemplateIcon.resolveIconFile(location, classLoader));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid icon location: " + location + ", " + e.getMessage(), e);
        }
    }

    private static String resolveIconFile(String path, ClassLoader classLoader) throws IOException {
        String base64Data;
        URL resource = classLoader.getResource(path);
        if (resource == null) {
            throw new IllegalArgumentException("Icon file not found: " + path);
        }
        try (InputStream stream = resource.openStream();){
            byte[] bytes = stream.readAllBytes();
            base64Data = Base64.getEncoder().encodeToString(bytes);
        }
        if (path.endsWith(".svg")) {
            return "data:image/svg+xml;base64," + base64Data;
        }
        if (path.endsWith(".png")) {
            return "data:image/png;base64," + base64Data;
        }
        throw new IllegalArgumentException("Unsupported icon file: " + path);
    }
}

