/*
 * Decompiled with CFR 0.152.
 */
package connector.com.fasterxml.jackson.module.scala.modifiers;

import connector.com.fasterxml.jackson.databind.JavaType;
import connector.com.fasterxml.jackson.databind.type.CollectionLikeType;
import connector.com.fasterxml.jackson.databind.type.MapLikeType;
import connector.com.fasterxml.jackson.databind.type.ReferenceType;
import connector.com.fasterxml.jackson.databind.type.TypeBindings;
import connector.com.fasterxml.jackson.databind.type.TypeFactory;
import connector.com.fasterxml.jackson.databind.type.TypeModifier;
import java.lang.reflect.Type;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.IntMap;
import scala.collection.immutable.LongMap;
import scala.util.Either;

public class ScalaTypeModifier
extends TypeModifier {
    private final Class<Option<?>> optionClass = Option.class;
    private final Class<Either<?, ?>> eitherClass = Either.class;
    private final Class<Map<?, ?>> mapClass = Map.class;
    private final Class<Object> intClass = Integer.TYPE;
    private final Class<IntMap<?>> intMapClass = IntMap.class;
    private final Class<Object> longClass = Long.TYPE;
    private final Class<LongMap<?>> immutableLongMapClass = LongMap.class;
    private final Class<scala.collection.mutable.LongMap<?>> mutableLongMapClass = scala.collection.mutable.LongMap.class;
    private final Class<IterableOnce<?>> iterableOnceClass = IterableOnce.class;

    @Override
    public JavaType modifyType(JavaType javaType, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
        if (javaType.isTypeOrSubTypeOf(this.optionClass)) {
            JavaType javaType2 = javaType;
            if (javaType2 instanceof ReferenceType) {
                ReferenceType rt = (ReferenceType)javaType2;
                return rt;
            }
            return ReferenceType.upgradeFrom(javaType, javaType.containedTypeOrUnknown(0));
        }
        if (javaType.isTypeOrSubTypeOf(this.mapClass)) {
            if (javaType.isTypeOrSubTypeOf(this.intMapClass)) {
                return MapLikeType.upgradeFrom(javaType, typeFactory.constructType(this.intClass), javaType.containedTypeOrUnknown(0));
            }
            if (javaType.isTypeOrSubTypeOf(this.immutableLongMapClass) || javaType.isTypeOrSubTypeOf(this.mutableLongMapClass)) {
                return MapLikeType.upgradeFrom(javaType, typeFactory.constructType(this.longClass), javaType.containedTypeOrUnknown(0));
            }
            return MapLikeType.upgradeFrom(javaType, javaType.containedTypeOrUnknown(0), javaType.containedTypeOrUnknown(1));
        }
        if (javaType.isTypeOrSubTypeOf(this.iterableOnceClass)) {
            return CollectionLikeType.upgradeFrom(javaType, javaType.containedTypeOrUnknown(0));
        }
        if (javaType.isTypeOrSubTypeOf(this.eitherClass)) {
            return ReferenceType.upgradeFrom(javaType, javaType);
        }
        return javaType;
    }
}

