/*
 * Decompiled with CFR 0.152.
 */
package connector.com.fasterxml.jackson.module.scala.deser;

import connector.com.fasterxml.jackson.core.JsonParser;
import connector.com.fasterxml.jackson.core.JsonToken;
import connector.com.fasterxml.jackson.databind.BeanProperty;
import connector.com.fasterxml.jackson.databind.DeserializationConfig;
import connector.com.fasterxml.jackson.databind.DeserializationContext;
import connector.com.fasterxml.jackson.databind.JavaType;
import connector.com.fasterxml.jackson.databind.JsonDeserializer;
import connector.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import connector.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import connector.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import connector.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import connector.com.fasterxml.jackson.module.scala.deser.EitherDeserializer$ElementDeserializerConfig$;
import connector.com.fasterxml.jackson.module.scala.deser.OptionDeserializer;
import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public class EitherDeserializer
extends StdDeserializer<Either<Object, Object>>
implements ContextualDeserializer {
    private final JavaType javaType;
    private final DeserializationConfig config;
    private final ElementDeserializerConfig leftDeserializerConfig;
    private final ElementDeserializerConfig rightDeserializerConfig;

    public EitherDeserializer(JavaType javaType, DeserializationConfig config, ElementDeserializerConfig leftDeserializerConfig, ElementDeserializerConfig rightDeserializerConfig) {
        this.javaType = javaType;
        this.config = config;
        this.leftDeserializerConfig = leftDeserializerConfig;
        this.rightDeserializerConfig = rightDeserializerConfig;
        super(Either.class);
    }

    public JsonDeserializer<Either<Object, Object>> createContextual(DeserializationContext ctxt, BeanProperty property) {
        int n = this.javaType.containedTypeCount();
        if (2 == n) {
            ElementDeserializerConfig leftDeserializerConfig = this.deserializerConfigFor$1(ctxt, 0, property);
            ElementDeserializerConfig rightDeserializerConfig = this.deserializerConfigFor$1(ctxt, 1, property);
            return new EitherDeserializer(this.javaType, this.config, leftDeserializerConfig, rightDeserializerConfig);
        }
        if (1 == n) {
            String string2 = this.javaType.getBindings().getBoundName(0);
            String string3 = "A";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                ElementDeserializerConfig leftDeserializerConfig = this.deserializerConfigFor$1(ctxt, 0, property);
                return new EitherDeserializer(this.javaType, this.config, leftDeserializerConfig, EitherDeserializer$ElementDeserializerConfig$.MODULE$.empty());
            }
            ElementDeserializerConfig rightDeserializerConfig = this.deserializerConfigFor$1(ctxt, 0, property);
            return new EitherDeserializer(this.javaType, this.config, EitherDeserializer$ElementDeserializerConfig$.MODULE$.empty(), rightDeserializerConfig);
        }
        return this;
    }

    private Object deserializeValue(JsonToken type, ElementDeserializerConfig config, JsonParser jp, DeserializationContext ctxt) {
        Tuple2<ElementDeserializerConfig, JsonToken> tuple2 = Tuple2$.MODULE$.apply(config, type);
        if (tuple2 != null) {
            ElementDeserializerConfig elementDeserializerConfig = tuple2._1();
            JsonToken jsonToken = tuple2._2();
            if (elementDeserializerConfig != null) {
                ElementDeserializerConfig elementDeserializerConfig2 = EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
                Option<JsonDeserializer<Object>> option = elementDeserializerConfig2._1();
                Option<TypeDeserializer> option2 = elementDeserializerConfig2._2();
                if (option instanceof Some) {
                    JsonDeserializer ed = (JsonDeserializer)((Some)option).value();
                    JsonToken jsonToken2 = JsonToken.VALUE_NULL;
                    JsonToken jsonToken3 = jsonToken;
                    if (!(jsonToken2 != null ? !((Object)((Object)jsonToken2)).equals((Object)jsonToken3) : jsonToken3 != null) && ed instanceof OptionDeserializer) {
                        return None$.MODULE$;
                    }
                }
            }
            JsonToken jsonToken4 = JsonToken.VALUE_NULL;
            JsonToken jsonToken5 = jsonToken;
            if (!(jsonToken4 != null ? !((Object)((Object)jsonToken4)).equals((Object)jsonToken5) : jsonToken5 != null)) {
                return None$.MODULE$.orNull($less$colon$less$.MODULE$.refl());
            }
            if (elementDeserializerConfig != null) {
                ElementDeserializerConfig elementDeserializerConfig3 = EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
                Option<JsonDeserializer<Object>> option = elementDeserializerConfig3._1();
                Option<TypeDeserializer> option3 = elementDeserializerConfig3._2();
                if (option instanceof Some) {
                    JsonDeserializer jsonDeserializer;
                    JsonDeserializer ed = jsonDeserializer = (JsonDeserializer)((Some)option).value();
                    if (option3 instanceof Some) {
                        TypeDeserializer td = (TypeDeserializer)((Some)option3).value();
                        return ed.deserializeWithType(jp, ctxt, td);
                    }
                    JsonDeserializer ed2 = jsonDeserializer;
                    return ed2.deserialize(jp, ctxt);
                }
            }
            return ctxt.handleUnexpectedToken(this.javaType.getRawClass(), jp);
        }
        throw new MatchError(tuple2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Either<Object, Object> deserializeEither(JsonParser jp, DeserializationContext ctxt) {
        Either either;
        block17: {
            JsonToken jsonToken;
            block15: {
                Either either2;
                block16: {
                    jsonToken = jp.currentToken();
                    JsonToken jsonToken2 = JsonToken.START_OBJECT;
                    JsonToken jsonToken3 = jsonToken;
                    if (jsonToken2 != null ? !((Object)((Object)jsonToken2)).equals((Object)jsonToken3) : jsonToken3 != null) break block15;
                    String key = jp.nextFieldName();
                    JsonToken type = jp.nextToken();
                    String string2 = key;
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 108: {
                            if (!"l".equals(string2)) break;
                            either2 = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                        case 114: {
                            if (!"r".equals(string2)) break;
                            either2 = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                        case 3317767: {
                            if (!"left".equals(string2)) break;
                            either2 = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                        case 108511772: {
                            if (!"right".equals(string2)) break;
                            either2 = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                    }
                    either2 = (Left)ctxt.handleUnexpectedToken(this.javaType, jp);
                }
                Left result = either2;
                jp.nextToken();
                return result;
            }
            JsonToken jsonToken4 = JsonToken.START_ARRAY;
            JsonToken jsonToken5 = jsonToken;
            if (jsonToken4 == null) {
                if (jsonToken5 != null) {
                    return (Either)ctxt.handleUnexpectedToken(this.javaType, jp);
                }
            } else if (!((Object)((Object)jsonToken4)).equals((Object)jsonToken5)) return (Either)ctxt.handleUnexpectedToken(this.javaType, jp);
            String key = jp.nextTextValue();
            JsonToken type = jp.nextToken();
            String string3 = key;
            switch (string3 == null ? 0 : string3.hashCode()) {
                case 108: {
                    if (!"l".equals(string3)) break;
                    either = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                    break block17;
                }
                case 114: {
                    if (!"r".equals(string3)) break;
                    either = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                    break block17;
                }
                case 3317767: {
                    if (!"left".equals(string3)) break;
                    either = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                    break block17;
                }
                case 108511772: {
                    if (!"right".equals(string3)) break;
                    either = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                    break block17;
                }
            }
            either = (Left)ctxt.handleUnexpectedToken(this.javaType, jp);
        }
        Left result = either;
        jp.nextToken();
        return result;
    }

    @Override
    public Either<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) {
        return this.deserializeEither(jp, ctxt);
    }

    @Override
    public Either<Object, Object> deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) {
        return this.deserializeEither(jp, ctxt);
    }

    private final ElementDeserializerConfig deserializerConfigFor$1(DeserializationContext ctxt$1, int param2, BeanProperty property) {
        JavaType containedType = this.javaType.containedType(param2);
        Option<JsonDeserializer<Object>> paramDeserializer = Option$.MODULE$.apply(ctxt$1.findContextualValueDeserializer(containedType, property));
        Option<TypeDeserializer> typeDeserializer = Option$.MODULE$.apply(property).flatMap((Function1<BeanProperty, Option> & Serializable)p -> Option$.MODULE$.apply(BeanDeserializerFactory.instance.findPropertyTypeDeserializer(ctxt$1.getConfig(), containedType, p.getMember())));
        return EitherDeserializer$ElementDeserializerConfig$.MODULE$.apply(paramDeserializer, typeDeserializer);
    }

    public static class ElementDeserializerConfig
    implements Product,
    Serializable {
        private final Option deserializer;
        private final Option typeDeserializer;

        public static ElementDeserializerConfig apply(Option<JsonDeserializer<Object>> option, Option<TypeDeserializer> option2) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.apply(option, option2);
        }

        public static ElementDeserializerConfig empty() {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.empty();
        }

        public static ElementDeserializerConfig fromProduct(Product product) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.fromProduct(product);
        }

        public static ElementDeserializerConfig unapply(ElementDeserializerConfig elementDeserializerConfig) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
        }

        public ElementDeserializerConfig(Option<JsonDeserializer<Object>> deserializer, Option<TypeDeserializer> typeDeserializer) {
            this.deserializer = deserializer;
            this.typeDeserializer = typeDeserializer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ElementDeserializerConfig)) return false;
            ElementDeserializerConfig elementDeserializerConfig = (ElementDeserializerConfig)object;
            Option<JsonDeserializer<Object>> option = this.deserializer();
            Option<JsonDeserializer<Object>> option2 = elementDeserializerConfig.deserializer();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<TypeDeserializer> option3 = this.typeDeserializer();
            Option<TypeDeserializer> option4 = elementDeserializerConfig.typeDeserializer();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!elementDeserializerConfig.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ElementDeserializerConfig;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "ElementDeserializerConfig";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "deserializer";
            }
            if (1 == n2) {
                return "typeDeserializer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Option<JsonDeserializer<Object>> deserializer() {
            return this.deserializer;
        }

        public Option<TypeDeserializer> typeDeserializer() {
            return this.typeDeserializer;
        }

        public ElementDeserializerConfig copy(Option<JsonDeserializer<Object>> deserializer, Option<TypeDeserializer> typeDeserializer) {
            return new ElementDeserializerConfig(deserializer, typeDeserializer);
        }

        public Option<JsonDeserializer<Object>> copy$default$1() {
            return this.deserializer();
        }

        public Option<TypeDeserializer> copy$default$2() {
            return this.typeDeserializer();
        }

        public Option<JsonDeserializer<Object>> _1() {
            return this.deserializer();
        }

        public Option<TypeDeserializer> _2() {
            return this.typeDeserializer();
        }
    }
}

