/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import io.camunda.connector.api.error.ConnectorInputException;
import io.camunda.connector.common.auth.OAuthAuthentication;
import io.camunda.connector.common.model.CommonRequest;
import io.camunda.connector.common.model.HttpRequestBuilder;
import io.camunda.connector.http.components.GsonComponentSupplier;
import io.camunda.connector.http.model.HttpJsonRequest;
import jakarta.validation.ValidationException;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.http.entity.ContentType;

public class HttpRequestMapper {
    private HttpRequestMapper() {
    }

    public static HttpRequest toOAuthHttpRequest(HttpRequestFactory requestFactory, HttpJsonRequest request) throws IOException {
        OAuthAuthentication authentication = (OAuthAuthentication)request.getAuthentication();
        HttpHeaders headers = new HttpHeaders();
        if (authentication.getClientAuthentication().equals("basicAuthHeader")) {
            headers.setBasicAuthentication(authentication.getClientId(), authentication.getClientSecret());
        }
        headers.setContentType("application/x-www-form-urlencoded");
        return new HttpRequestBuilder().method("POST").genericUrl(new GenericUrl(authentication.getOauthTokenEndpoint())).content((HttpContent)new UrlEncodedContent((Object)authentication.getDataForAuthRequestBody())).headers(headers).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).followRedirects(false).build(requestFactory);
    }

    public static HttpRequest toHttpRequest(HttpRequestFactory requestFactory, CommonRequest request) throws IOException {
        return HttpRequestMapper.toHttpRequest(requestFactory, request, null);
    }

    public static HttpRequest toHttpRequest(HttpRequestFactory requestFactory, CommonRequest request, String bearerToken) throws IOException {
        if (request.getUrl().contains("computeMetadata")) {
            throw new ConnectorInputException((Throwable)new ValidationException("The provided URL is not allowed"));
        }
        GenericUrl genericUrl = new GenericUrl(request.getUrl());
        HttpHeaders headers = HttpRequestMapper.createHeaders(request, bearerToken);
        if (request.hasQueryParameters()) {
            genericUrl.putAll(request.getQueryParameters());
        }
        if (request.hasBody() && request.getBody() instanceof String) {
            String unescapeBody = StringEscapeUtils.unescapeJson((String)((String)request.getBody()));
            request.setBody((Object)unescapeBody);
        }
        Object content = ContentType.APPLICATION_FORM_URLENCODED.getMimeType().equalsIgnoreCase(headers.getContentType()) ? new UrlEncodedContent(request.getBody()) : (request.hasBody() ? new JsonHttpContent((JsonFactory)GsonComponentSupplier.gsonFactoryInstance(), request.getBody()) : null);
        return new HttpRequestBuilder().method(request.getMethod().toUpperCase()).genericUrl(genericUrl).content((HttpContent)content).headers(headers).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).followRedirects(false).build(requestFactory);
    }

    private static HttpHeaders createHeaders(CommonRequest request, String bearerToken) {
        boolean isContentTypeNotSet;
        HttpHeaders httpHeaders = new HttpHeaders();
        if (request.hasBody() && (isContentTypeNotSet = Optional.ofNullable(request.getHeaders()).map(headers -> headers.entrySet().stream().noneMatch(header -> ((String)header.getKey()).equalsIgnoreCase("content-type"))).orElse(true).booleanValue())) {
            httpHeaders.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        }
        if (request.hasAuthentication()) {
            if (bearerToken != null && !bearerToken.isEmpty()) {
                httpHeaders.setAuthorization("Bearer " + bearerToken);
            }
            request.getAuthentication().setHeaders(httpHeaders);
        }
        if (request.hasHeaders()) {
            httpHeaders.putAll(request.getHeaders());
        }
        return httpHeaders;
    }
}

