/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.gson.Gson;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.common.auth.CustomAuthentication;
import io.camunda.connector.common.auth.OAuthAuthentication;
import io.camunda.connector.common.model.CommonRequest;
import io.camunda.connector.common.services.AuthenticationService;
import io.camunda.connector.common.services.HTTPProxyService;
import io.camunda.connector.common.services.HTTPService;
import io.camunda.connector.http.HttpRequestMapper;
import io.camunda.connector.http.model.HttpJsonRequest;
import io.camunda.connector.http.model.HttpJsonResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpService.class);
    private final Gson gson;
    private final HttpRequestFactory requestFactory;
    private final String proxyFunctionUrl;

    public HttpService(Gson gson, HttpRequestFactory requestFactory, String proxyFunctionUrl) {
        this.gson = gson;
        this.requestFactory = requestFactory;
        this.proxyFunctionUrl = proxyFunctionUrl;
    }

    public Object executeConnectorRequest(HttpJsonRequest request) throws IOException, InstantiationException, IllegalAccessException {
        return this.proxyFunctionUrl == null ? this.executeRequestDirectly(request) : this.executeRequestViaProxy(request);
    }

    private HttpJsonResult executeRequestDirectly(HttpJsonRequest request) throws IOException, InstantiationException, IllegalAccessException {
        String bearerToken = null;
        HTTPService httpService = new HTTPService(this.gson);
        AuthenticationService authService = new AuthenticationService(this.gson, this.requestFactory);
        if (request.getAuthentication() != null) {
            if (request.getAuthentication() instanceof OAuthAuthentication) {
                bearerToken = this.getTokenFromOAuthRequest(request, httpService, authService);
            } else if (request.getAuthentication() instanceof CustomAuthentication) {
                CustomAuthentication authentication = (CustomAuthentication)request.getAuthentication();
                HttpRequest httpRequest = HttpRequestMapper.toHttpRequest(this.requestFactory, authentication.getRequest());
                HttpResponse httpResponse = httpService.executeHttpRequest(httpRequest);
                if (httpResponse.isSuccessStatusCode()) {
                    authService.fillRequestFromCustomAuthResponseData((CommonRequest)request, authentication, httpResponse);
                } else {
                    throw new RuntimeException("Authenticate is fail; status code : [" + httpResponse.getStatusCode() + "], message : [" + httpResponse.getStatusMessage() + "]");
                }
            }
        }
        HttpRequest httpRequest = HttpRequestMapper.toHttpRequest(this.requestFactory, request, bearerToken);
        HttpResponse httpResponse = httpService.executeHttpRequest(httpRequest, false);
        return (HttpJsonResult)httpService.toHttpResponse(httpResponse, HttpJsonResult.class);
    }

    private String getTokenFromOAuthRequest(HttpJsonRequest connectorRequest, HTTPService httpService, AuthenticationService authService) throws IOException {
        HttpRequest oauthRequest = authService.createOAuthRequest((CommonRequest)connectorRequest);
        HttpResponse oauthResponse = httpService.executeHttpRequest(oauthRequest);
        return authService.extractOAuthAccessToken(oauthResponse);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private HttpJsonResult executeRequestViaProxy(HttpJsonRequest request) throws IOException {
        HttpRequest httpRequest = HTTPProxyService.toRequestViaProxy((Gson)this.gson, (HttpRequestFactory)this.requestFactory, (CommonRequest)request, (String)this.proxyFunctionUrl);
        HTTPService httpService = new HTTPService(this.gson);
        HttpResponse httpResponse = httpService.executeHttpRequest(httpRequest, true);
        try (InputStream responseContentStream = httpResponse.getContent();){
            HttpJsonResult httpJsonResult;
            try (InputStreamReader reader = new InputStreamReader(responseContentStream);){
                HttpJsonResult jsonResult = (HttpJsonResult)((Object)this.gson.fromJson((Reader)reader, HttpJsonResult.class));
                LOGGER.debug("Proxy returned result: " + jsonResult);
                httpJsonResult = jsonResult;
            }
            return httpJsonResult;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse external response: {}", (Object)httpResponse, (Object)e);
            throw new ConnectorException("Failed to parse result: " + e.getMessage(), (Throwable)e);
        }
    }
}

