/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.json.JsonHttpContent;
import io.camunda.connector.common.auth.OAuthAuthentication;
import io.camunda.connector.common.model.CommonRequest;
import io.camunda.connector.common.model.HttpRequestBuilder;
import io.camunda.connector.http.components.GsonComponentSupplier;
import io.camunda.connector.http.model.HttpJsonRequest;
import io.camunda.connector.impl.ConnectorInputException;
import java.io.IOException;
import java.util.Map;
import javax.validation.ValidationException;
import org.apache.http.entity.ContentType;

public class HttpRequestMapper {
    private HttpRequestMapper() {
    }

    public static HttpRequest toOAuthHttpRequest(HttpRequestFactory requestFactory, HttpJsonRequest request) throws IOException {
        OAuthAuthentication authentication = (OAuthAuthentication)request.getAuthentication();
        HttpHeaders headers = new HttpHeaders();
        if (authentication.getClientAuthentication().equals("basicAuthHeader")) {
            headers.setBasicAuthentication(authentication.getClientId(), authentication.getClientSecret());
        }
        headers.setContentType("application/x-www-form-urlencoded");
        return new HttpRequestBuilder().method("POST").genericUrl(new GenericUrl(authentication.getOauthTokenEndpoint())).content(new UrlEncodedContent(authentication.getDataForAuthRequestBody())).headers(headers).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).followRedirects(false).build(requestFactory);
    }

    public static HttpRequest toHttpRequest(HttpRequestFactory requestFactory, CommonRequest request) throws IOException {
        return HttpRequestMapper.toHttpRequest(requestFactory, request, null);
    }

    public static HttpRequest toHttpRequest(HttpRequestFactory requestFactory, CommonRequest request, String bearerToken) throws IOException {
        if (request.getUrl().contains("computeMetadata")) {
            throw new ConnectorInputException((Throwable)new ValidationException("The provided URL is not allowed"));
        }
        GenericUrl genericUrl = new GenericUrl(request.getUrl());
        HttpHeaders headers = HttpRequestMapper.createHeaders(request, bearerToken);
        if (request.hasQueryParameters()) {
            genericUrl.putAll((Map<? extends String, ?>)request.getQueryParameters());
        }
        return new HttpRequestBuilder().method(request.getMethod().toUpperCase()).genericUrl(genericUrl).content(request.hasBody() ? new JsonHttpContent(GsonComponentSupplier.gsonFactoryInstance(), request.getBody()) : null).headers(headers).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).followRedirects(false).build(requestFactory);
    }

    private static HttpHeaders createHeaders(CommonRequest request, String bearerToken) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (request.hasBody()) {
            httpHeaders.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        }
        if (request.hasAuthentication()) {
            if (bearerToken != null && !bearerToken.isEmpty()) {
                httpHeaders.setAuthorization("Bearer " + bearerToken);
            }
            request.getAuthentication().setHeaders(httpHeaders);
        }
        if (request.hasHeaders()) {
            httpHeaders.putAll((Map<? extends String, ?>)request.getHeaders());
        }
        return httpHeaders;
    }
}

