/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http;

import com.google.api.client.http.HttpRequestFactory;
import com.google.gson.Gson;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.http.HttpService;
import io.camunda.connector.http.components.GsonComponentSupplier;
import io.camunda.connector.http.components.HttpTransportComponentSupplier;
import io.camunda.connector.http.model.HttpJsonRequest;
import io.camunda.connector.impl.config.ConnectorConfigurationUtil;
import java.io.IOException;

@OutboundConnector(name="HTTPJSON", inputVariables={"url", "method", "authentication", "headers", "queryParameters", "connectionTimeoutInSeconds", "body"}, type="io.camunda:http-json:1")
public class HttpJsonFunction
implements OutboundConnectorFunction {
    private final Gson gson;
    private final HttpService httpService;

    public HttpJsonFunction() {
        this(ConnectorConfigurationUtil.getProperty((String)"CAMUNDA_CONNECTOR_HTTP_PROXY_URL"));
    }

    public HttpJsonFunction(String proxyFunctionUrl) {
        this(GsonComponentSupplier.gsonInstance(), HttpTransportComponentSupplier.httpRequestFactoryInstance(), proxyFunctionUrl);
    }

    public HttpJsonFunction(Gson gson, HttpRequestFactory requestFactory, String proxyFunctionUrl) {
        this.httpService = new HttpService(gson, requestFactory, proxyFunctionUrl);
        this.gson = gson;
    }

    public Object execute(OutboundConnectorContext context) throws IOException, InstantiationException, IllegalAccessException {
        String json = context.getVariables();
        HttpJsonRequest request = this.gson.fromJson(json, HttpJsonRequest.class);
        context.validate((Object)request);
        context.replaceSecrets((Object)request);
        return this.httpService.executeConnectorRequest(request);
    }
}

