/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.camunda.connector.common.utils.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ResponseParser {
    private ResponseParser() {
    }

    public static Map<String, String> extractPropertiesFromBody(Map<String, String> requestedProperties, String strResponse, Gson gson) {
        if (requestedProperties == null || requestedProperties.isEmpty()) {
            return null;
        }
        JsonElement asJsonElement = Optional.ofNullable(JsonHelper.getAsJsonElement(strResponse, gson)).orElseThrow(() -> new IllegalArgumentException("Authentication response body is empty"));
        HashMap<String, String> extractedProperties = new HashMap<String, String>();
        requestedProperties.forEach((k, v) -> {
            String[] fromRequests;
            JsonElement responseCopy = asJsonElement.deepCopy();
            for (String fromRequest : fromRequests = v.trim().split("\\.")) {
                String[] split = fromRequest.split(":");
                String actionString = split[0].trim();
                if (actionString.equalsIgnoreCase("asObject")) {
                    responseCopy = Optional.ofNullable(responseCopy.getAsJsonObject()).map(obj -> obj.get(split[1].trim())).orElseThrow(() -> new IllegalArgumentException("Failed to getting [" + split[1].trim() + "] from authentication response"));
                    continue;
                }
                if (actionString.equalsIgnoreCase("asArray")) {
                    responseCopy = Optional.ofNullable(responseCopy.getAsJsonArray()).map(s2 -> s2.get(Integer.parseInt(split[1].trim()))).orElseThrow(() -> new IllegalArgumentException("Failed to get element # [" + split[1].trim() + "] from authentication response"));
                    continue;
                }
                if (actionString.equalsIgnoreCase("asString")) {
                    String result = responseCopy.getAsString();
                    if (result == null) {
                        throw new RuntimeException("Fail to parse to String [" + responseCopy + "] from authentication response");
                    }
                    extractedProperties.put((String)k, result);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported action [" + actionString + "] in parsing pattern");
            }
        });
        return extractedProperties.isEmpty() ? null : extractedProperties;
    }
}

