/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.common.services;

import com.google.api.client.http.HttpRequest;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.OAuth2Credentials;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyOAuthHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyOAuthHelper.class);

    private ProxyOAuthHelper() {
    }

    public static OAuth2Credentials initializeCredentials(String proxyUrl) {
        if (proxyUrl == null) {
            return null;
        }
        try {
            IdTokenProvider idTokenProvider = ProxyOAuthHelper.createIdTokenProvider();
            return ProxyOAuthHelper.createIdTokenCredentials(proxyUrl, idTokenProvider);
        }
        catch (Exception ex) {
            LOGGER.warn("Could not wire OAuth for proxy, not using OAuth", ex);
            return null;
        }
    }

    public static void addOauthHeaders(HttpRequest request, OAuth2Credentials credentials) throws IOException {
        if (credentials != null) {
            credentials.refreshIfExpired();
            request.getHeaders().setAuthorization("Bearer " + credentials.getAccessToken().getTokenValue());
        }
    }

    private static IdTokenProvider createIdTokenProvider() throws IOException {
        GoogleCredentials googleCredentials = GoogleCredentials.getApplicationDefault();
        if (!(googleCredentials instanceof IdTokenProvider)) {
            throw new IOException("Google Credentials are not an instance of IdTokenProvider.");
        }
        return (IdTokenProvider)((Object)googleCredentials);
    }

    private static IdTokenCredentials createIdTokenCredentials(String url, IdTokenProvider idTokenProvider) {
        return IdTokenCredentials.newBuilder().setIdTokenProvider(idTokenProvider).setTargetAudience(url).build();
    }
}

