/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.common.services;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.gson.Gson;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.common.model.CommonRequest;
import io.camunda.connector.common.model.CommonResult;
import io.camunda.connector.common.model.ErrorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPService.class);
    private final Gson gson;

    public HTTPService(Gson gson) {
        this.gson = gson;
    }

    public HttpHeaders createHeaders(CommonRequest request, String bearerToken) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            httpHeaders.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        }
        if (request.hasAuthentication()) {
            if (bearerToken != null && !bearerToken.isEmpty()) {
                httpHeaders.setAuthorization("Bearer " + bearerToken);
            }
            request.getAuthentication().setHeaders(httpHeaders);
        }
        return httpHeaders;
    }

    public HttpResponse executeHttpRequest(HttpRequest externalRequest) throws IOException {
        return this.executeHttpRequest(externalRequest, false);
    }

    public HttpResponse executeHttpRequest(HttpRequest externalRequest, boolean isProxyCall) throws IOException {
        try {
            return externalRequest.execute();
        }
        catch (HttpResponseException hrex) {
            String errorCode = String.valueOf(hrex.getStatusCode());
            String errorMessage = hrex.getMessage();
            if (isProxyCall && hrex.getContent() != null) {
                try {
                    ErrorResponse errorContent = this.gson.fromJson(hrex.getContent(), ErrorResponse.class);
                    errorCode = errorContent.getErrorCode();
                    errorMessage = errorContent.getError();
                }
                catch (Exception e) {
                    LOGGER.warn("Error response cannot be parsed as JSON! Will use the plain message.");
                }
            }
            throw new ConnectorException(errorCode, errorMessage, (Throwable)hrex);
        }
    }

    public <T extends CommonResult> T toHttpJsonResponse(HttpResponse externalResponse, Class<T> resultClass) throws InstantiationException, IllegalAccessException {
        CommonResult connectorResult = (CommonResult)resultClass.newInstance();
        connectorResult.setStatus(externalResponse.getStatusCode());
        HashMap<String, Object> headers = new HashMap<String, Object>();
        externalResponse.getHeaders().forEach((k, v) -> {
            if (v instanceof List && ((List)v).size() == 1) {
                headers.put((String)k, ((List)v).get(0));
            } else {
                headers.put((String)k, v);
            }
        });
        connectorResult.setHeaders(headers);
        try (InputStream content = externalResponse.getContent();
             InputStreamReader reader = new InputStreamReader(content);){
            Object body = this.gson.fromJson((Reader)reader, Object.class);
            if (body != null) {
                connectorResult.setBody(body);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse external response: {}", (Object)externalResponse, (Object)e);
        }
        return (T)connectorResult;
    }
}

