/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.common.services;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.gson.Gson;
import io.camunda.connector.common.model.CommonRequest;
import io.camunda.connector.common.model.HttpRequestBuilder;
import io.camunda.connector.common.services.ProxyOAuthHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public final class HTTPProxyService {
    public static HttpRequest toRequestViaProxy(Gson gson, HttpRequestFactory requestFactory, CommonRequest request, String proxyFunctionUrl) throws IOException {
        final String contentAsJson = gson.toJson(request);
        AbstractHttpContent content = new AbstractHttpContent("application/json; charset=UTF-8"){

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                outputStream.write(contentAsJson.getBytes(StandardCharsets.UTF_8));
            }
        };
        HttpRequest httpRequest = new HttpRequestBuilder().method("POST").genericUrl(new GenericUrl(proxyFunctionUrl)).content(content).connectionTimeoutInSeconds(request.getConnectionTimeoutInSeconds()).followRedirects(false).build(requestFactory);
        ProxyOAuthHelper.addOauthHeaders(httpRequest, ProxyOAuthHelper.initializeCredentials(proxyFunctionUrl));
        return httpRequest;
    }
}

