/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.common.services;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.camunda.connector.common.auth.CustomAuthentication;
import io.camunda.connector.common.auth.OAuthAuthentication;
import io.camunda.connector.common.model.CommonRequest;
import io.camunda.connector.common.utils.JsonHelper;
import io.camunda.connector.common.utils.ResponseParser;
import io.camunda.connector.common.utils.Timeout;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AuthenticationService {
    private final Gson gson;
    private final HttpRequestFactory requestFactory;

    public AuthenticationService(Gson gson, HttpRequestFactory requestFactory) {
        this.gson = gson;
        this.requestFactory = requestFactory;
    }

    public String extractOAuthAccessToken(HttpResponse oauthResponse) throws IOException {
        return Optional.ofNullable(JsonHelper.getAsJsonElement(oauthResponse.parseAsString(), this.gson)).map(JsonElement::getAsJsonObject).map(jsonObject -> jsonObject.get("access_token")).map(JsonElement::getAsString).orElse(null);
    }

    public void fillRequestFromCustomAuthResponseData(CommonRequest request, CustomAuthentication authentication, HttpResponse httpResponse) throws IOException {
        Map<String, String> body;
        String strResponse = httpResponse.parseAsString();
        Map<String, String> headers = ResponseParser.extractPropertiesFromBody(authentication.getOutputHeaders(), strResponse, this.gson);
        if (headers != null) {
            if (!request.hasHeaders()) {
                request.setHeaders(new HashMap<String, String>());
            }
            request.getHeaders().putAll(headers);
        }
        if ((body = ResponseParser.extractPropertiesFromBody(authentication.getOutputBody(), strResponse, this.gson)) != null) {
            if (!request.hasBody()) {
                request.setBody(new Object());
            }
            JsonObject requestBody = this.gson.toJsonTree(request.getBody()).getAsJsonObject();
            body.forEach(requestBody::addProperty);
            request.setBody(this.gson.fromJson(this.gson.toJson(requestBody), Object.class));
        }
    }

    public HttpRequest createOAuthRequest(CommonRequest request) throws IOException {
        OAuthAuthentication authentication = (OAuthAuthentication)request.getAuthentication();
        GenericUrl genericUrl = new GenericUrl(authentication.getOauthTokenEndpoint());
        Map<String, String> data = authentication.getDataForAuthRequestBody();
        UrlEncodedContent content = new UrlEncodedContent(data);
        String method = "POST";
        HttpRequest httpRequest = this.requestFactory.buildRequest("POST", genericUrl, content);
        httpRequest.setFollowRedirects(false);
        Timeout.setTimeout(request, httpRequest);
        HttpHeaders headers = new HttpHeaders();
        if ("basicAuthHeader".equals(authentication.getClientAuthentication())) {
            headers.setBasicAuthentication(authentication.getClientId(), authentication.getClientSecret());
        }
        headers.setContentType("application/x-www-form-urlencoded");
        httpRequest.setHeaders(headers);
        return httpRequest;
    }
}

