/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.common.model;

import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.common.auth.Authentication;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

public class CommonRequest {
    @NotBlank
    @Pattern(regexp="^(http://|https://|secrets|\\{\\{).*$")
    @Secret
    private @NotBlank @Pattern(regexp="^(http://|https://|secrets|\\{\\{).*$") String url;
    @NotBlank
    @Secret
    private String method;
    @Valid
    @Secret
    private Authentication authentication;
    @Pattern(regexp="^([0-9]*$)|(secrets.*$)")
    @Secret
    private @Pattern(regexp="^([0-9]*$)|(secrets.*$)") String connectionTimeoutInSeconds;
    @Secret
    private Map<String, String> headers;
    @Secret
    private Object body;
    @Secret
    private Map<String, String> queryParameters;

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean hasQueryParameters() {
        return this.queryParameters != null;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getConnectionTimeoutInSeconds() {
        return this.connectionTimeoutInSeconds;
    }

    public void setConnectionTimeoutInSeconds(String connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonRequest that = (CommonRequest)o;
        return this.url.equals(that.url) && this.method.equals(that.method) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.connectionTimeoutInSeconds, that.connectionTimeoutInSeconds) && Objects.equals(this.headers, that.headers) && Objects.equals(this.body, that.body) && Objects.equals(this.queryParameters, that.queryParameters);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.method, this.authentication, this.connectionTimeoutInSeconds, this.headers, this.body, this.queryParameters);
    }

    public String toString() {
        return "CommonRequest{url='" + this.url + "', method='" + this.method + "', authentication=" + this.authentication + ", connectionTimeoutInSeconds='" + this.connectionTimeoutInSeconds + "', headers=" + this.headers + ", body=" + this.body + ", queryParameters=" + this.queryParameters + "}";
    }
}

