/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.common.auth;

import com.google.api.client.http.HttpHeaders;
import com.google.common.base.Objects;
import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.common.auth.Authentication;
import java.util.function.Function;
import javax.validation.constraints.NotEmpty;

public class BasicAuthentication
extends Authentication {
    private static final String SPEC_PASSWORD_EMPTY_PATTERN = "SPEC_PASSWORD_EMPTY_PATTERN";
    private static final Function<String, String> SPEC_PASSWORD = psw -> psw.equals(SPEC_PASSWORD_EMPTY_PATTERN) ? "" : psw;
    @NotEmpty
    @Secret
    private String username;
    @NotEmpty
    @Secret
    private String password;

    @Override
    public void setHeaders(HttpHeaders headers) {
        headers.setBasicAuthentication(this.username, SPEC_PASSWORD.apply(this.password));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasicAuthentication that = (BasicAuthentication)o;
        return Objects.equal(this.username, that.username) && Objects.equal(this.password, that.password);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.username, this.password);
    }

    @Override
    public String toString() {
        return "BasicAuthentication {username='[REDACTED]', password='[REDACTED]'}; Super: " + super.toString();
    }
}

