/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.model;

import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.http.auth.Authentication;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

public class HttpJsonRequest {
    @NotBlank
    @Secret
    private String method;
    @NotBlank
    @Pattern(regexp="^(http://|https://|secrets).*$")
    @Secret
    private @NotBlank @Pattern(regexp="^(http://|https://|secrets).*$") String url;
    @Valid
    @Secret
    private Authentication authentication;
    @Secret
    private Map<String, String> queryParameters;
    @Secret
    private Map<String, String> headers;
    @Pattern(regexp="^([0-9]*$)|(secrets.*$)")
    @Secret
    private @Pattern(regexp="^([0-9]*$)|(secrets.*$)") String connectionTimeoutInSeconds;
    @Secret
    private Object body;

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public boolean hasQueryParameters() {
        return this.queryParameters != null;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getConnectionTimeoutInSeconds() {
        return this.connectionTimeoutInSeconds;
    }

    public void setConnectionTimeoutInSeconds(String connectionTimeoutInSeconds) {
        this.connectionTimeoutInSeconds = connectionTimeoutInSeconds;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpJsonRequest that = (HttpJsonRequest)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.url, that.url) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.queryParameters, that.queryParameters) && Objects.equals(this.headers, that.headers) && Objects.equals(this.connectionTimeoutInSeconds, that.connectionTimeoutInSeconds) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode(this.method, this.url, this.authentication, this.queryParameters, this.headers, this.body);
    }

    public String toString() {
        return "HttpJsonRequest{method='" + this.method + "', url='" + this.url + "', authentication=" + this.authentication + ", queryParameters=" + this.queryParameters + ", headers=" + this.headers + ", connectionTimeoutInSeconds='" + this.connectionTimeoutInSeconds + "', body=" + this.body + "}";
    }
}

