/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.auth;

import com.google.api.client.http.HttpHeaders;
import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.http.auth.Authentication;
import java.util.Objects;
import javax.validation.constraints.NotEmpty;

public class OAuthAuthentication
extends Authentication {
    private final String grantType = "client_credentials";
    @NotEmpty
    @Secret
    private String oauthTokenEndpoint;
    @NotEmpty
    @Secret
    private String clientId;
    @NotEmpty
    @Secret
    private String clientSecret;
    @Secret
    private String audience;
    @NotEmpty
    private String clientAuthentication;
    private String scopes;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getGrantType() {
        return "client_credentials";
    }

    public String getOauthTokenEndpoint() {
        return this.oauthTokenEndpoint;
    }

    public void setOauthTokenEndpoint(String oauthTokenEndpoint) {
        this.oauthTokenEndpoint = oauthTokenEndpoint;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(String clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    @Override
    public void setHeaders(HttpHeaders headers) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthAuthentication that = (OAuthAuthentication)o;
        return this.oauthTokenEndpoint.equals(that.oauthTokenEndpoint) && this.clientId.equals(that.clientId) && this.clientSecret.equals(that.clientSecret) && this.audience.equals(that.audience) && Objects.equals("client_credentials", that.grantType) && this.clientAuthentication.equals(that.clientAuthentication) && Objects.equals(this.scopes, that.scopes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oauthTokenEndpoint, this.clientId, this.clientSecret, this.audience, "client_credentials", this.clientAuthentication, this.scopes);
    }

    @Override
    public String toString() {
        return "OAuthAuthentication{grantType='client_credentials', oauthTokenEndpoint='" + this.oauthTokenEndpoint + "', audience='" + this.audience + "', clientAuthentication='" + this.clientAuthentication + "', scopes='" + this.scopes + "'} " + super.toString();
    }
}

