/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.auth;

import com.google.api.client.http.HttpHeaders;
import com.google.common.base.Objects;
import io.camunda.connector.api.annotation.Secret;
import io.camunda.connector.http.auth.Authentication;
import javax.validation.constraints.NotEmpty;

public class BearerAuthentication
extends Authentication {
    @NotEmpty
    @Secret
    private String token;

    @Override
    public void setHeaders(HttpHeaders headers) {
        headers.setAuthorization("Bearer " + this.token);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BearerAuthentication that = (BearerAuthentication)o;
        return Objects.equal(this.token, that.token);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.token);
    }

    @Override
    public String toString() {
        return "BearerAuthentication{token='[REDACTED]'}; Super: " + super.toString();
    }
}

