/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.gson.GsonFactory;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.error.ConnectorException;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.http.auth.OAuthAuthentication;
import io.camunda.connector.http.auth.ProxyOAuthHelper;
import io.camunda.connector.http.components.GsonComponentSupplier;
import io.camunda.connector.http.components.HttpTransportComponentSupplier;
import io.camunda.connector.http.model.ErrorResponse;
import io.camunda.connector.http.model.HttpJsonRequest;
import io.camunda.connector.http.model.HttpJsonResult;
import io.camunda.connector.impl.ConnectorInputException;
import io.camunda.connector.impl.config.ConnectorConfigurationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.ValidationException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OutboundConnector(name="HTTPJSON", inputVariables={"url", "method", "authentication", "headers", "queryParameters", "connectionTimeoutInSeconds", "body"}, type="io.camunda:http-json:1")
public class HttpJsonFunction
implements OutboundConnectorFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpJsonFunction.class);
    private final Gson gson;
    private final GsonFactory gsonFactory;
    private final HttpRequestFactory requestFactory;
    private final String proxyFunctionUrl;
    private final OAuth2Credentials proxyCredentials;

    public HttpJsonFunction() {
        this(ConnectorConfigurationUtil.getProperty((String)"CAMUNDA_CONNECTOR_HTTP_PROXY_URL"));
    }

    public HttpJsonFunction(String proxyFunctionUrl) {
        this(GsonComponentSupplier.gsonInstance(), HttpTransportComponentSupplier.httpRequestFactoryInstance(), GsonComponentSupplier.gsonFactoryInstance(), proxyFunctionUrl);
    }

    public HttpJsonFunction(Gson gson, HttpRequestFactory requestFactory, GsonFactory gsonFactory, String proxyFunctionUrl) {
        this.gson = gson;
        this.requestFactory = requestFactory;
        this.gsonFactory = gsonFactory;
        this.proxyFunctionUrl = proxyFunctionUrl;
        this.proxyCredentials = ProxyOAuthHelper.initializeCredentials(proxyFunctionUrl);
    }

    public Object execute(OutboundConnectorContext context) throws IOException {
        String json = context.getVariables();
        HttpJsonRequest request = this.gson.fromJson(json, HttpJsonRequest.class);
        context.validate((Object)request);
        context.replaceSecrets((Object)request);
        if (this.proxyFunctionUrl != null) {
            return this.executeRequestViaProxy(request);
        }
        return this.executeRequestDirectly(request);
    }

    protected HttpJsonResult executeRequestDirectly(HttpJsonRequest request) throws IOException {
        String bearerToken = null;
        if (request.getAuthentication() != null && request.getAuthentication() instanceof OAuthAuthentication) {
            HttpRequest oauthRequest = this.createOAuthRequest(request);
            HttpResponse oauthResponse = this.executeHttpRequest(oauthRequest, false);
            bearerToken = this.extractAccessToken(oauthResponse);
        }
        HttpRequest httpRequest = this.createRequest(request, bearerToken);
        HttpResponse httpResponse = this.executeHttpRequest(httpRequest, false);
        return this.toHttpJsonResponse(httpResponse);
    }

    protected String extractAccessToken(HttpResponse oauthResponse) throws IOException {
        JsonObject jsonObject;
        String oauthResponseStr = oauthResponse.parseAsString();
        if (oauthResponseStr != null && !oauthResponseStr.isEmpty() && (jsonObject = this.gson.fromJson(oauthResponseStr, JsonObject.class)).get("access_token") != null) {
            return jsonObject.get("access_token").getAsString();
        }
        return null;
    }

    protected HttpRequest createOAuthRequest(HttpJsonRequest request) throws IOException {
        OAuthAuthentication authentication = (OAuthAuthentication)request.getAuthentication();
        GenericUrl genericUrl = new GenericUrl(authentication.getOauthTokenEndpoint());
        Map<String, String> data = HttpJsonFunction.getDataForAuthRequestBody(authentication);
        UrlEncodedContent content = new UrlEncodedContent(data);
        String method = "POST";
        HttpRequest httpRequest = this.requestFactory.buildRequest("POST", genericUrl, content);
        httpRequest.setFollowRedirects(false);
        this.setTimeout(request, httpRequest);
        HttpHeaders headers = new HttpHeaders();
        if (authentication.getClientAuthentication().equals("basicAuthHeader")) {
            headers.setBasicAuthentication(authentication.getClientId(), authentication.getClientSecret());
        }
        headers.setContentType("application/x-www-form-urlencoded");
        httpRequest.setHeaders(headers);
        return httpRequest;
    }

    private static Map<String, String> getDataForAuthRequestBody(OAuthAuthentication authentication) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("grant_type", authentication.getGrantType());
        data.put("audience", authentication.getAudience());
        data.put("scope", authentication.getScopes());
        if (authentication.getClientAuthentication().equals("credentialsBody")) {
            data.put("client_id", authentication.getClientId());
            data.put("client_secret", authentication.getClientSecret());
        }
        return data;
    }

    protected HttpResponse executeHttpRequest(HttpRequest externalRequest, boolean isProxyCall) throws IOException {
        try {
            return externalRequest.execute();
        }
        catch (HttpResponseException hrex) {
            String errorCode = String.valueOf(hrex.getStatusCode());
            String errorMessage = hrex.getMessage();
            if (isProxyCall && hrex.getContent() != null) {
                try {
                    ErrorResponse errorContent = this.gson.fromJson(hrex.getContent(), ErrorResponse.class);
                    errorCode = errorContent.getErrorCode();
                    errorMessage = errorContent.getError();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new ConnectorException(errorCode, errorMessage, (Throwable)hrex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected HttpJsonResult executeRequestViaProxy(HttpJsonRequest request) throws IOException {
        final String contentAsJson = this.gson.toJson(request);
        AbstractHttpContent content = new AbstractHttpContent("application/json; charset=UTF-8"){

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                outputStream.write(contentAsJson.getBytes(StandardCharsets.UTF_8));
            }
        };
        GenericUrl genericUrl = new GenericUrl(this.proxyFunctionUrl);
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(genericUrl, content);
        httpRequest.setFollowRedirects(false);
        this.setTimeout(request, httpRequest);
        ProxyOAuthHelper.addOauthHeaders(httpRequest, this.proxyCredentials);
        HttpResponse httpResponse = this.executeHttpRequest(httpRequest, true);
        try (InputStream responseContentStream = httpResponse.getContent();){
            HttpJsonResult httpJsonResult;
            try (InputStreamReader reader = new InputStreamReader(responseContentStream);){
                HttpJsonResult jsonResult = this.gson.fromJson((Reader)reader, HttpJsonResult.class);
                LOGGER.debug("Proxy returned result: " + jsonResult);
                httpJsonResult = jsonResult;
            }
            return httpJsonResult;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to parse external response: {}", (Object)httpResponse, (Object)e);
            throw new ConnectorException("Failed to parse result: " + e.getMessage(), (Throwable)e);
        }
    }

    protected HttpRequest createRequest(HttpJsonRequest request, String bearerToken) throws IOException {
        if (request.getUrl().contains("computeMetadata")) {
            throw new ConnectorInputException((Throwable)new ValidationException("The provided URL is not allowed"));
        }
        String method = request.getMethod().toUpperCase();
        GenericUrl genericUrl = new GenericUrl(request.getUrl());
        HttpContent content = this.createContent(request);
        HttpHeaders headers = this.createHeaders(request, bearerToken);
        if (request.hasQueryParameters()) {
            genericUrl.putAll((Map<? extends String, ?>)request.getQueryParameters());
        }
        HttpRequest httpRequest = this.requestFactory.buildRequest(method, genericUrl, content);
        httpRequest.setFollowRedirects(false);
        this.setTimeout(request, httpRequest);
        httpRequest.setHeaders(headers);
        return httpRequest;
    }

    protected void setTimeout(HttpJsonRequest request, HttpRequest httpRequest) {
        if (request.getConnectionTimeoutInSeconds() != null) {
            long connectionTimeout = TimeUnit.SECONDS.toMillis(Long.parseLong(request.getConnectionTimeoutInSeconds()));
            int intConnectionTimeout = Math.toIntExact(connectionTimeout);
            httpRequest.setConnectTimeout(intConnectionTimeout);
            httpRequest.setReadTimeout(intConnectionTimeout);
            httpRequest.setWriteTimeout(intConnectionTimeout);
        }
    }

    protected HttpContent createContent(HttpJsonRequest request) {
        if (request.hasBody()) {
            return new JsonHttpContent(this.gsonFactory, request.getBody());
        }
        return null;
    }

    protected HttpHeaders createHeaders(HttpJsonRequest request, String bearerToken) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (request.hasBody()) {
            httpHeaders.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        }
        if (request.hasAuthentication()) {
            if (bearerToken != null && !bearerToken.isEmpty()) {
                httpHeaders.setAuthorization("Bearer " + bearerToken);
            }
            request.getAuthentication().setHeaders(httpHeaders);
        }
        if (request.hasHeaders()) {
            httpHeaders.putAll((Map<? extends String, ?>)request.getHeaders());
        }
        return httpHeaders;
    }

    protected HttpJsonResult toHttpJsonResponse(HttpResponse externalResponse) {
        HttpJsonResult httpJsonResult = new HttpJsonResult();
        httpJsonResult.setStatus(externalResponse.getStatusCode());
        HashMap<String, Object> headers = new HashMap<String, Object>();
        externalResponse.getHeaders().forEach((k, v) -> {
            if (v instanceof List && ((List)v).size() == 1) {
                headers.put((String)k, ((List)v).get(0));
            } else {
                headers.put((String)k, v);
            }
        });
        httpJsonResult.setHeaders(headers);
        try (InputStream content = externalResponse.getContent();
             InputStreamReader reader = new InputStreamReader(content);){
            Object body = this.gson.fromJson((Reader)reader, Object.class);
            if (body != null) {
                httpJsonResult.setBody(body);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse external response: {}", (Object)externalResponse, (Object)e);
        }
        return httpJsonResult;
    }
}

