/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import io.camunda.connector.generator.dsl.Property;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyCondition;
import io.camunda.connector.generator.dsl.PropertyConstraints;

public abstract class PropertyBuilder {
    protected String id;
    protected String label;
    protected String description;
    protected Boolean optional;
    protected String value;
    protected Property.GeneratedValue generatedValue;
    protected PropertyConstraints constraints;
    protected Property.FeelMode feel;
    protected String group;
    protected PropertyBinding binding;
    protected String type;
    protected PropertyCondition condition;

    protected PropertyBuilder() {
    }

    public String getId() {
        return this.id;
    }

    public PropertyBinding getBinding() {
        return this.binding;
    }

    public PropertyCondition getCondition() {
        return this.condition;
    }

    public PropertyBuilder id(String name) {
        this.id = name;
        return this;
    }

    public PropertyBuilder label(String label) {
        this.label = label;
        return this;
    }

    public PropertyBuilder description(String description) {
        this.description = description;
        return this;
    }

    public PropertyBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public PropertyBuilder value(String value) {
        if (this.generatedValue != null) {
            throw new IllegalStateException("Generated value is already set");
        }
        this.value = value;
        return this;
    }

    public PropertyBuilder generatedValue() {
        if (this.value != null) {
            throw new IllegalStateException("Value is already set");
        }
        this.generatedValue = new Property.GeneratedValue("uuid");
        return this;
    }

    public PropertyBuilder constraints(PropertyConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public PropertyBuilder feel(Property.FeelMode feel) {
        this.feel = feel;
        return this;
    }

    public PropertyBuilder binding(PropertyBinding binding) {
        this.binding = binding;
        return this;
    }

    public PropertyBuilder condition(PropertyCondition condition) {
        this.condition = condition;
        return this;
    }

    public PropertyBuilder group(String group) {
        this.group = group;
        return this;
    }

    public abstract Property build();
}

