/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.generator.dsl;

import connector.com.fasterxml.jackson.annotation.JsonInclude;
import io.camunda.connector.generator.dsl.BooleanProperty;
import io.camunda.connector.generator.dsl.DropdownProperty;
import io.camunda.connector.generator.dsl.HiddenProperty;
import io.camunda.connector.generator.dsl.PropertyBinding;
import io.camunda.connector.generator.dsl.PropertyCondition;
import io.camunda.connector.generator.dsl.PropertyConstraints;
import io.camunda.connector.generator.dsl.StringProperty;
import io.camunda.connector.generator.dsl.TextProperty;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract sealed class Property
permits BooleanProperty, DropdownProperty, HiddenProperty, StringProperty, TextProperty {
    protected final String id;
    protected final String label;
    protected final String description;
    protected final Boolean optional;
    protected final String value;
    protected final GeneratedValue generatedValue;
    protected final PropertyConstraints constraints;
    protected final FeelMode feel;
    protected final String group;
    protected final PropertyBinding binding;
    protected final PropertyCondition condition;
    protected final String type;

    public Property(String id, String label, String description, Boolean optional, String value, GeneratedValue generatedValue, PropertyConstraints constraints, FeelMode feel, String group, PropertyBinding binding, PropertyCondition condition, String type) {
        this.id = id;
        this.label = label;
        this.description = description;
        this.optional = optional;
        this.value = value;
        this.generatedValue = generatedValue;
        this.constraints = constraints;
        this.feel = feel;
        this.group = group;
        this.binding = binding;
        this.condition = condition;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isOptional() {
        return this.optional;
    }

    public String getValue() {
        return this.value;
    }

    public GeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    public PropertyConstraints getConstraints() {
        return this.constraints;
    }

    public FeelMode getFeel() {
        if (this.feel == FeelMode.disabled) {
            return null;
        }
        return this.feel;
    }

    public String getGroup() {
        return this.group;
    }

    public PropertyBinding getBinding() {
        return this.binding;
    }

    public String getType() {
        return this.type;
    }

    public PropertyCondition getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return this.optional == property.optional && Objects.equals(this.id, property.id) && Objects.equals(this.label, property.label) && Objects.equals(this.description, property.description) && Objects.equals(this.value, property.value) && Objects.equals(this.generatedValue, property.generatedValue) && Objects.equals(this.constraints, property.constraints) && this.feel == property.feel && Objects.equals(this.group, property.group) && Objects.equals(this.binding, property.binding) && Objects.equals(this.type, property.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.label, this.description, this.optional, this.value, this.generatedValue, this.constraints, this.feel, this.group, this.binding, this.type});
    }

    public String toString() {
        return "Property{id='" + this.id + "', label='" + this.label + "', description='" + this.description + "', optional=" + this.optional + ", value='" + this.value + "', generatedValue='" + String.valueOf(this.generatedValue) + "', constraints=" + String.valueOf(this.constraints) + ", feel=" + String.valueOf((Object)this.feel) + ", group='" + this.group + "', binding=" + String.valueOf(this.binding) + ", type='" + this.type + "'}";
    }

    public record GeneratedValue(String type) {
    }

    public static enum FeelMode {
        optional,
        required,
        disabled;

    }
}

