/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.http.base.utils;

import com.google.api.client.http.HttpRequest;
import io.camunda.connector.http.base.model.HttpCommonRequest;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static void copyTimeoutFrom(HttpCommonRequest request, HttpRequest httpRequest) {
        Timeout.copyTimeoutFrom(httpRequest, request.getConnectionTimeoutInSeconds(), request.getReadTimeoutInSeconds(), request.getWriteTimeoutInSeconds());
    }

    public static void copyTimeoutFrom(HttpRequest httpRequest, Integer connectionTimeoutInSeconds, Integer readTimeoutInSeconds, Integer writeTimeoutInSeconds) {
        Optional<Integer> connectionTimeoutInMillis = Timeout.toMillis(connectionTimeoutInSeconds);
        connectionTimeoutInMillis.ifPresent(httpRequest::setConnectTimeout);
        Timeout.toMillis(readTimeoutInSeconds).ifPresent(httpRequest::setReadTimeout);
        Timeout.toMillis(writeTimeoutInSeconds).ifPresent(httpRequest::setWriteTimeout);
        if (writeTimeoutInSeconds == null && readTimeoutInSeconds == null) {
            connectionTimeoutInMillis.ifPresent(timeout -> {
                httpRequest.setReadTimeout((int)timeout);
                httpRequest.setWriteTimeout((int)timeout);
            });
        }
    }

    private static Optional<Integer> toMillis(Integer seconds) {
        return Optional.ofNullable(seconds).map(s2 -> Math.toIntExact(TimeUnit.SECONDS.toMillis(s2.intValue())));
    }
}

